<?php
// Process password change BEFORE any output
if (isset($_POST['change_password'])) {
    // Start session and connect to database
session_start();
    include '../includes/db.php';

    // Check if user is Admin
    if ($_SESSION['user_peranan'] !== 'Admin') {
        header('Location: ../index.php');
    exit;
}

    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];
    
    try {
        // Get current user's password hash
        $stmt = $conn->prepare("SELECT password FROM users WHERE iduser = ?");
        $stmt->bind_param('i', $_SESSION['user_id']);
        $stmt->execute();
        $result = $stmt->get_result();
        $user = $result->fetch_assoc();
        $stmt->close();
        
        // Verify current password
        if (!password_verify($current_password, $user['password'])) {
            throw new Exception("Password semasa tidak betul!");
        } elseif (strlen($new_password) < 6) {
            throw new Exception("Password baru mesti sekurang-kurangnya 6 aksara!");
        } elseif ($new_password !== $confirm_password) {
            throw new Exception("Pengesahan password baru tidak sepadan!");
        }
        
        // Update password
        $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
        $stmt = $conn->prepare("UPDATE users SET password = ? WHERE iduser = ?");
        $stmt->bind_param('si', $hashed_password, $_SESSION['user_id']);
        $stmt->execute();
        $stmt->close();
        
        $success = "Password berjaya ditukar!";
        
    } catch (Exception $e) {
        // Log error
        error_log("Error in admin/password.php: " . $e->getMessage());
        
        // Show error message instead of blank page
        $error = $e->getMessage();
    }
}

// Set page variables for header
$page_title = 'Tukar Password';
$page_subtitle = 'Tukar Password';
$current_page = 'password';
$base_path = '';

// Include header (includes session_start, db connection, and shop info)
include '../includes/header.php';

// Check if user is Admin
if ($_SESSION['user_peranan'] !== 'Admin') {
    header('Location: ../index.php');
    exit;
}


// Get current user info
$stmt = $conn->prepare("SELECT username, realname, peranan FROM users WHERE iduser = ?");
$stmt->bind_param('i', $_SESSION['user_id']);
$stmt->execute();
$result = $stmt->get_result();
$user_info = $result->fetch_assoc();
$stmt->close();
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-key"></i> Tukar Password</h1>
    <a href="../index.php" class="btn btn-secondary btn-modern">
        <i class="bi bi-arrow-left"></i> Kembali ke Senarai
                </a>
            </div>

<?php if (isset($success)): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle"></i> <?= $success ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            
<?php if (isset($error)): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="bi bi-exclamation-triangle"></i> <?= $error ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

<div class="row">
    <!-- Tukar Password Form -->
    <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-key"></i> Tukar Password</h5>
                        </div>
                        <div class="card-body">
                            <form method="post">
                                <div class="mb-3">
                                    <label class="form-label">Password Semasa</label>
                                    <input type="password" name="current_password" class="form-control" required>
                                    <small class="text-muted">Masukkan password semasa untuk mengesahkan identiti anda</small>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Password Baru</label>
                        <input type="password" name="new_password" class="form-control" required minlength="6">
                                    <small class="text-muted">Password baru mesti sekurang-kurangnya 6 aksara</small>
                                </div>
                    <div class="mb-3">
                                    <label class="form-label">Pengesahan Password Baru</label>
                        <input type="password" name="confirm_password" class="form-control" required minlength="6">
                                    <small class="text-muted">Masukkan semula password baru untuk pengesahan</small>
                                </div>
                    <button type="submit" name="change_password" class="btn btn-primary btn-modern">
                        <i class="bi bi-check-circle"></i> Tukar Password
                                </button>
                            </form>
            </div>
                        </div>
                    </div>
                    
    <!-- Maklumat Pengguna -->
    <div class="col-md-4">
        <div class="card">
                        <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-info-circle"></i> Maklumat</h5>
                        </div>
                        <div class="card-body">
                <p class="mb-2"><strong>Username:</strong> <?= htmlspecialchars($user_info['username']) ?></p>
                <p class="mb-2"><strong>Nama:</strong> <?= htmlspecialchars($user_info['realname']) ?></p>
                <p class="mb-2"><strong>Peranan:</strong> <?= htmlspecialchars($user_info['peranan']) ?></p>
                <p class="mb-0"><small class="text-muted">Nota: Password disimpan dalam database dengan hash yang selamat.</small></p>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?> 