        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
// Mobile Modal Handler - Ensures modals work properly on mobile devices
document.addEventListener('DOMContentLoaded', function() {
    const isMobile = window.innerWidth <= 767.98 || /Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
    
    if (isMobile) {
        console.log('Mobile device detected, setting up mobile modal handlers');
        
        // Function to move modal to body to avoid container constraints
        function moveModalToBody(modalElement) {
            if (modalElement && modalElement.parentElement && modalElement.parentElement !== document.body) {
                console.log('Moving modal to body to avoid container constraints');
                document.body.appendChild(modalElement);
            }
        }
        
        // Handle modal buttons for mobile - SIMPLE APPROACH
        document.querySelectorAll('[data-bs-toggle="modal"]').forEach(button => {
            button.addEventListener('click', function(e) {
                if (window.innerWidth <= 767.98) {
                    e.preventDefault();
                    e.stopPropagation();
                    
                    const targetModal = this.getAttribute('data-bs-target');
                    console.log('Mobile modal button clicked:', targetModal);
                    
                    if (targetModal) {
                        const modalElement = document.querySelector(targetModal);
                        if (modalElement) {
                            // Close sidebar first
                            const sidebar = document.querySelector('.sidebar');
                            if (sidebar && sidebar.classList.contains('show')) {
                                if (typeof toggleSidebar === 'function') {
                                    toggleSidebar();
                                }
                            }
                            
                            // Move modal to body first to avoid container constraints
                            moveModalToBody(modalElement);
                            
                            // Show modal with forced styles - ensure it's not constrained by table
                            modalElement.style.cssText = `
                                position: fixed !important;
                                top: 0 !important;
                                left: 0 !important;
                                width: 100vw !important;
                                height: 100vh !important;
                                z-index: 9999 !important;
                                display: flex !important;
                                align-items: center !important;
                                justify-content: center !important;
                                background: rgba(0,0,0,0.5) !important;
                                transform: none !important;
                                overflow: visible !important;
                            `;
                            modalElement.classList.add('show');
                            document.body.classList.add('modal-open');
                            
                            // Force modal dialog styles
                            const dialog = modalElement.querySelector('.modal-dialog');
                            if (dialog) {
                                const isPortrait = window.innerHeight > window.innerWidth;
                                const margin = isPortrait ? '2px 10px 15px 10px' : '5px 15px 20px 15px';
                                const paddingTop = isPortrait ? '0vh' : '2vh';
                                
                                dialog.style.cssText = `
                                    margin: ${margin} !important;
                                    max-width: calc(100vw - 30px) !important;
                                    width: 100% !important;
                                    display: flex !important;
                                    align-items: flex-start !important;
                                    justify-content: center !important;
                                    padding-top: ${paddingTop} !important;
                                `;
                            }
                            
                            // Force modal content styles
                            const content = modalElement.querySelector('.modal-content');
                            if (content) {
                                const isPortrait = window.innerHeight > window.innerWidth;
                                const maxHeight = isPortrait ? '70vh' : '75vh';
                                
                                content.style.cssText = `
                                    background: white !important;
                                    border-radius: 8px !important;
                                    box-shadow: 0 8px 25px rgba(0,0,0,0.3) !important;
                                    max-height: ${maxHeight} !important;
                                    overflow-y: auto !important;
                                    position: relative !important;
                                    width: 100% !important;
                                    z-index: 10001 !important;
                                `;
                            }
                            
                            // Handle close buttons
                            const closeButtons = modalElement.querySelectorAll('.btn-close, [data-bs-dismiss="modal"], .btn-secondary');
                            closeButtons.forEach(closeBtn => {
                                closeBtn.addEventListener('click', function(e) {
                                    e.preventDefault();
                                    e.stopPropagation();
                                    
                                    modalElement.style.display = 'none';
                                    modalElement.classList.remove('show');
                                    document.body.classList.remove('modal-open');
                                    
                                    console.log('Mobile modal closed');
                                });
                            });
                            
                            // Handle backdrop click
                            modalElement.addEventListener('click', function(e) {
                                if (e.target === modalElement) {
                                    modalElement.style.display = 'none';
                                    modalElement.classList.remove('show');
                                    document.body.classList.remove('modal-open');
                                    
                                    console.log('Mobile modal closed by backdrop');
                                }
                            });
                            
                            // Make form inputs work properly
                            setTimeout(() => {
                                const inputs = modalElement.querySelectorAll('input, textarea, select');
                                inputs.forEach(input => {
                                    input.readOnly = false;
                                    input.disabled = false;
                                    input.style.pointerEvents = 'auto';
                                    input.style.userSelect = 'auto';
                                    input.style.webkitUserSelect = 'auto';
                                });
                            }, 100);
                            
                            console.log('Mobile modal shown with forced styles');
                        }
                    }
                }
            });
        });
        
        // Handle Bootstrap modal events
        document.addEventListener('show.bs.modal', function(e) {
            const modal = e.target;
            if (window.innerWidth <= 767.98) {
                // Force modal to be visible and not constrained by parent
                setTimeout(() => {
                    // Move modal to body if it's inside a table or other container
                    if (modal.parentElement && modal.parentElement !== document.body) {
                        document.body.appendChild(modal);
                    }
                    
                    modal.style.cssText = `
                        position: fixed !important;
                        top: 0 !important;
                        left: 0 !important;
                        width: 100vw !important;
                        height: 100vh !important;
                        z-index: 9999 !important;
                        display: flex !important;
                        align-items: center !important;
                        justify-content: center !important;
                        background: rgba(0,0,0,0.5) !important;
                        transform: none !important;
                        overflow: visible !important;
                    `;
                    
                    // Apply smaller styles to modal content
                    const dialog = modal.querySelector('.modal-dialog');
                    if (dialog) {
                        const isPortrait = window.innerHeight > window.innerWidth;
                        const margin = isPortrait ? '2px 10px 15px 10px' : '5px 15px 20px 15px';
                        const paddingTop = isPortrait ? '0vh' : '2vh';
                        
                        dialog.style.margin = margin;
                        dialog.style.maxWidth = 'calc(100vw - 30px)';
                        dialog.style.alignItems = 'flex-start';
                        dialog.style.paddingTop = paddingTop;
                    }
                    
                    const content = modal.querySelector('.modal-content');
                    if (content) {
                        const isPortrait = window.innerHeight > window.innerWidth;
                        const maxHeight = isPortrait ? '70vh' : '75vh';
                        
                        content.style.borderRadius = '8px';
                        content.style.maxHeight = maxHeight;
                    }
                    
                    // Hide Bootstrap backdrop
                    const backdrop = document.querySelector('.modal-backdrop');
                    if (backdrop) {
                        backdrop.style.display = 'none';
                    }
                }, 10);
            }
        });
        
        // Handle modal close events
        document.addEventListener('hidden.bs.modal', function(e) {
            const modal = e.target;
            if (window.innerWidth <= 767.98) {
                modal.style.display = 'none';
                modal.classList.remove('show');
                document.body.classList.remove('modal-open');
                
                // Remove any remaining backdrops
                const backdrops = document.querySelectorAll('.modal-backdrop');
                backdrops.forEach(backdrop => backdrop.remove());
            }
        });
        
        // Handle orientation change for modals
        window.addEventListener('orientationchange', function() {
            setTimeout(() => {
                const openModals = document.querySelectorAll('.modal.show');
                openModals.forEach(modal => {
                    const content = modal.querySelector('.modal-content');
                    const dialog = modal.querySelector('.modal-dialog');
                    
                    if (content && dialog) {
                        const isPortrait = window.innerHeight > window.innerWidth;
                        const maxHeight = isPortrait ? '70vh' : '75vh';
                        const margin = isPortrait ? '2px 10px 15px 10px' : '5px 15px 20px 15px';
                        const paddingTop = isPortrait ? '0vh' : '2vh';
                        
                        content.style.maxHeight = maxHeight;
                        dialog.style.margin = margin;
                        dialog.style.paddingTop = paddingTop;
                    }
                });
            }, 100);
        });
    }
});

function toggleSidebar() {
    const sidebar = document.querySelector('.sidebar');
    const overlay = document.querySelector('.sidebar-overlay');
    const body = document.body;
    const menuToggle = document.querySelector('.menu-toggle');
    
    sidebar.classList.toggle('show');
    overlay.classList.toggle('show');
    
    if (sidebar.classList.contains('show')) {
        body.classList.add('sidebar-open');
        // Hide menu button when sidebar is open
        menuToggle.classList.add('hidden');
    } else {
        body.classList.remove('sidebar-open');
        // Show menu button when sidebar is closed
        menuToggle.classList.remove('hidden');
    }
}

// Close sidebar when clicking on a link (mobile) - REMOVED TO PREVENT CONFLICTS
// This will be handled in the mobile-specific section below

// Close sidebar when clicking on overlay
document.querySelector('.sidebar-overlay').addEventListener('click', () => {
    if (window.innerWidth <= 767.98) {
        toggleSidebar();
    }
});

// Enhanced window resize handler
window.addEventListener('resize', () => {
    const sidebar = document.querySelector('.sidebar');
    const overlay = document.querySelector('.sidebar-overlay');
    const body = document.body;
    const menuToggle = document.querySelector('.menu-toggle');
    
    if (window.innerWidth > 767.98) {
        sidebar.classList.remove('show');
        overlay.classList.remove('show');
        body.classList.remove('sidebar-open');
        menuToggle.classList.remove('hidden');
    }
});

// Close sidebar on escape key
document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape') {
        const sidebar = document.querySelector('.sidebar');
        if (sidebar.classList.contains('show')) {
            toggleSidebar();
        }
    }
});

// Auto-hide sidebar when clicking outside (for larger screens)
document.addEventListener('click', (e) => {
    const sidebar = document.querySelector('.sidebar');
    const toggle = document.querySelector('.menu-toggle');
    
    if (window.innerWidth <= 767.98 && 
        sidebar.classList.contains('show') && 
        !sidebar.contains(e.target) && 
        !toggle.contains(e.target)) {
        toggleSidebar();
    }
});

// Initialize sidebar state on page load
document.addEventListener('DOMContentLoaded', () => {
    // Global cleanup function for modals
    window.cleanupModal = () => {
        document.body.style.overflow = '';
        document.documentElement.style.overflow = '';
        document.body.style.position = '';
        document.body.style.top = '';
        document.body.style.paddingRight = '';
        document.documentElement.style.paddingRight = '';
        document.body.classList.remove('modal-open', 'sidebar-open');
        document.documentElement.classList.remove('modal-open');
        
        // Remove any remaining modal backdrops
        const backdrops = document.querySelectorAll('.modal-backdrop, .mobile-modal-backdrop');
        backdrops.forEach(backdrop => backdrop.remove());
        
        console.log('Modal cleanup completed');
    };
    
    // Simple mobile modal cleanup function
    window.cleanupMobileModal = () => {
        console.log('Starting simple mobile modal cleanup...');
        
        // Hide all modal elements
        const allModals = document.querySelectorAll('.modal');
        allModals.forEach(modal => {
            modal.style.display = 'none';
            modal.classList.remove('show');
            console.log('Hidden modal');
        });
        
        // Remove any modal backdrops
        const backdrops = document.querySelectorAll('.modal-backdrop');
        console.log('Found backdrops:', backdrops.length);
        backdrops.forEach(backdrop => {
            backdrop.remove();
            console.log('Removed backdrop');
        });
        
        // Reset body styles
        document.body.style.overflow = '';
        document.body.classList.remove('modal-open');
        
        console.log('Simple mobile modal cleanup completed');
    };
    
    // Call cleanup on page load to ensure clean state
    window.cleanupModal();
    window.cleanupMobileModal();
    
    if (window.innerWidth <= 767.98) {
        document.querySelector('.sidebar').classList.remove('show');
        document.querySelector('.sidebar-overlay').classList.remove('show');
        document.body.classList.remove('sidebar-open');
        document.querySelector('.menu-toggle').classList.remove('hidden');
        
        // Ensure all modals are hidden on mobile
        const allModals = document.querySelectorAll('.modal');
        allModals.forEach(modal => {
            modal.style.display = 'none';
            modal.classList.remove('show');
        });
    }
    
    // Cleanup on page unload/refresh
    window.addEventListener('beforeunload', () => {
        window.cleanupMobileModal();
    });
    
            // Cleanup on page visibility change
        document.addEventListener('visibilitychange', () => {
            if (document.hidden) {
                window.cleanupMobileModal();
            }
        });
        
        // Simple cleanup on page events
        if (isMobile) {
            // Cleanup on page unload
            window.addEventListener('beforeunload', () => {
                window.cleanupMobileModal();
            });
            
            // Cleanup on visibility change
            document.addEventListener('visibilitychange', () => {
                if (document.hidden) {
                    window.cleanupMobileModal();
                }
            });
        }
    
        // Mobile-specific modal handling
    function showMobileModal(modalId) {
        console.log('showMobileModal called with:', modalId);
        
        const modalElement = document.querySelector(modalId);
        if (!modalElement) {
            console.error('Modal element not found:', modalId);
            return;
        }
        
        // Clean up any existing modals first
        const existingBackdrops = document.querySelectorAll('.mobile-modal-backdrop');
        existingBackdrops.forEach(backdrop => backdrop.remove());
        
        // Ensure body is not frozen
        document.body.style.overflow = '';
        document.documentElement.style.overflow = '';
        document.body.style.position = '';
        document.body.style.top = '';
        document.body.style.paddingRight = '';
        document.documentElement.style.paddingRight = '';
        
        // Create new backdrop
        const backdrop = document.createElement('div');
        backdrop.className = 'mobile-modal-backdrop';
        backdrop.style.cssText = `
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            background-color: rgba(0, 0, 0, 0.6);
            z-index: 9999;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        `;
        
        // Clone modal content
        const modalContent = modalElement.querySelector('.modal-content');
        if (modalContent) {
            const clonedContent = modalContent.cloneNode(true);
            clonedContent.style.cssText = `
                background: white;
                border-radius: 12px;
                max-width: 98%;
                width: 100%;
                max-height: 85vh;
                overflow-y: auto;
                box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
                position: relative;
                font-size: 14px;
            `;
            
            // Remove only Bootstrap close buttons, keep footer buttons
            const existingCloseButtons = clonedContent.querySelectorAll('.btn-close');
            existingCloseButtons.forEach(btn => btn.remove());
            
            // Add custom close button
            const closeBtn = document.createElement('button');
            closeBtn.innerHTML = '×';
            closeBtn.style.cssText = `
                position: absolute;
                top: 8px;
                right: 12px;
                background: none;
                border: none;
                font-size: 20px;
                font-weight: bold;
                color: #666;
                cursor: pointer;
                z-index: 10000;
                width: 28px;
                height: 28px;
                display: flex;
                align-items: center;
                justify-content: center;
                border-radius: 50%;
                transition: background-color 0.2s;
            `;
            
            // Add hover effect for close button
            closeBtn.addEventListener('mouseenter', () => {
                closeBtn.style.backgroundColor = '#f0f0f0';
            });
            
            closeBtn.addEventListener('mouseleave', () => {
                closeBtn.style.backgroundColor = 'transparent';
            });
            
            closeBtn.addEventListener('click', () => {
                console.log('X button clicked');
                setTimeout(() => {
                    window.cleanupMobileModal();
                }, 50);
            });
            
            clonedContent.appendChild(closeBtn);
            backdrop.appendChild(clonedContent);
            
            // Debug: Check modal content
            console.log('Modal content cloned:', clonedContent.innerHTML);
            console.log('Footer buttons found:', clonedContent.querySelectorAll('.modal-footer button').length);
            console.log('Forms found:', clonedContent.querySelectorAll('form').length);
            
            // Close on backdrop click
            backdrop.addEventListener('click', (e) => {
                if (e.target === backdrop) {
                    console.log('Backdrop clicked');
                    setTimeout(() => {
                        window.cleanupMobileModal();
                    }, 50);
                }
            });
            
            // Prevent backdrop from interfering with form interactions
            backdrop.addEventListener('touchstart', (e) => {
                if (e.target === backdrop) {
                    e.preventDefault();
                }
            });
            
            backdrop.addEventListener('mousedown', (e) => {
                if (e.target === backdrop) {
                    e.preventDefault();
                }
            });
            
            // Handle all buttons in the modal
            const allButtons = clonedContent.querySelectorAll('button');
            allButtons.forEach(btn => {
                btn.addEventListener('click', (e) => {
                    e.preventDefault();
                    e.stopPropagation();
                    
                    console.log('Button clicked:', btn.textContent.trim(), btn.type, btn.name);
                    
                    // Handle close buttons (Tutup, Batal)
                    if (btn.classList.contains('btn-secondary') || btn.getAttribute('data-bs-dismiss') === 'modal') {
                        console.log('Close button clicked');
                        setTimeout(() => {
                            window.cleanupMobileModal();
                        }, 50);
                        return;
                    }
                    
                    // Handle submit buttons (Simpan, Padam, etc.)
                    if (btn.type === 'submit' || btn.classList.contains('btn-primary') || btn.classList.contains('btn-warning') || btn.classList.contains('btn-danger')) {
                        console.log('Submit button clicked');
                        
                        // Find the form and submit it
                        const form = btn.closest('form');
                        if (form) {
                            console.log('Form found, submitting...');
                            // Submit form first, then cleanup
                            setTimeout(() => {
                                form.submit();
                                setTimeout(() => {
                                    window.cleanupMobileModal();
                                }, 200);
                            }, 50);
                        } else {
                            console.log('No form found');
                            setTimeout(() => {
                                window.cleanupMobileModal();
                            }, 50);
                        }
                        return;
                    }
                });
            });
            
            // Ensure form inputs are editable - NEW APPROACH
            const formInputs = clonedContent.querySelectorAll('input, textarea, select');
            formInputs.forEach(input => {
                console.log('Processing input:', input.name || input.type, input.value);
                
                // Remove any problematic attributes
                input.removeAttribute('readonly');
                input.removeAttribute('disabled');
                input.removeAttribute('tabindex');
                
                // Set input properties
                input.readOnly = false;
                input.disabled = false;
                
                // Set styles
                input.style.cssText = `
                    pointer-events: auto !important;
                    user-select: auto !important;
                    -webkit-user-select: auto !important;
                    -moz-user-select: auto !important;
                    -ms-user-select: auto !important;
                    background: white !important;
                    color: black !important;
                    border: 1px solid #ced4da !important;
                    padding: 8px 12px !important;
                    cursor: text !important;
                    opacity: 1 !important;
                    visibility: visible !important;
                    position: relative !important;
                    z-index: 10001 !important;
                `;
                
                // Remove any existing event listeners by cloning
                const newInput = input.cloneNode(true);
                newInput.value = input.value;
                newInput.checked = input.checked;
                newInput.selected = input.selected;
                
                // Set properties on new input
                newInput.readOnly = false;
                newInput.disabled = false;
                newInput.style.cssText = input.style.cssText;
                
                // Replace the input
                input.parentNode.replaceChild(newInput, input);
                
                // Add event listeners to new input
                newInput.addEventListener('click', (e) => {
                    console.log('Input clicked:', newInput.name || newInput.type);
                    e.stopPropagation();
                });
                
                newInput.addEventListener('focus', (e) => {
                    console.log('Input focused:', newInput.name || newInput.type);
                    e.stopPropagation();
                });
                
                newInput.addEventListener('input', (e) => {
                    console.log('Input changed:', newInput.name || newInput.type, newInput.value);
                    e.stopPropagation();
                });
                
                newInput.addEventListener('touchstart', (e) => {
                    console.log('Input touchstart:', newInput.name || newInput.type);
                    e.stopPropagation();
                });
                
                console.log('Input processed:', newInput.name || newInput.type);
            });
            
            // Handle form submission
            const forms = clonedContent.querySelectorAll('form');
            forms.forEach(form => {
                form.addEventListener('submit', (e) => {
                    console.log('Form submitted');
                    setTimeout(() => {
                        window.cleanupMobileModal();
                    }, 100);
                });
            });
            
            document.body.appendChild(backdrop);
            console.log('Mobile modal should be visible now');
        }
    }
    
    // Mobile-specific handlers
    const isMobile = window.innerWidth <= 767.98 || /Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
    
    if (isMobile) {
        console.log('Mobile device detected, setting up mobile handlers');
        
        // Override Bootstrap modal behavior for mobile
        const originalModal = window.bootstrap?.Modal;
        if (originalModal) {
            window.bootstrap.Modal = function(element, options) {
                const modal = new originalModal(element, options);
                
                // Override show method
                const originalShow = modal.show;
                modal.show = function() {
                    if (window.innerWidth <= 767.98) {
                        // Custom mobile show
                        element.style.display = 'flex';
                        element.classList.add('show');
                        document.body.classList.add('modal-open');
                        
                        // Close sidebar if open
                        const sidebar = document.querySelector('.sidebar');
                        if (sidebar && sidebar.classList.contains('show')) {
                            toggleSidebar();
                        }
                        
                        console.log('Mobile modal shown');
                    } else {
                        originalShow.call(this);
                    }
                };
                
                // Override hide method
                const originalHide = modal.hide;
                modal.hide = function() {
                    if (window.innerWidth <= 767.98) {
                        // Custom mobile hide
                        element.style.display = 'none';
                        element.classList.remove('show');
                        document.body.classList.remove('modal-open');
                        console.log('Mobile modal hidden');
                    } else {
                        originalHide.call(this);
                    }
                };
                
                return modal;
            };
        }
        
        // Handle modal buttons for mobile
        document.querySelectorAll('[data-bs-toggle="modal"]').forEach(button => {
            button.addEventListener('click', (e) => {
                if (window.innerWidth <= 767.98) {
                    e.preventDefault();
                    e.stopPropagation();
                    
                    const targetModal = button.getAttribute('data-bs-target');
                    console.log('Mobile modal button clicked:', targetModal);
                    
                    if (targetModal) {
                        const modalElement = document.querySelector(targetModal);
                        if (modalElement) {
                            // Close sidebar first
                            const sidebar = document.querySelector('.sidebar');
                            if (sidebar && sidebar.classList.contains('show')) {
                                toggleSidebar();
                            }
                            
                            // Show modal
                            modalElement.style.display = 'flex';
                            modalElement.classList.add('show');
                            document.body.classList.add('modal-open');
                            
                            // Handle close buttons
                            const closeButtons = modalElement.querySelectorAll('.btn-close, [data-bs-dismiss="modal"], .btn-secondary');
                            closeButtons.forEach(closeBtn => {
                                closeBtn.addEventListener('click', (e) => {
                                    e.preventDefault();
                                    e.stopPropagation();
                                    
                                    modalElement.style.display = 'none';
                                    modalElement.classList.remove('show');
                                    document.body.classList.remove('modal-open');
                                    
                                    console.log('Mobile modal closed');
                                });
                            });
                            
                            // Handle backdrop click
                            modalElement.addEventListener('click', (e) => {
                                if (e.target === modalElement) {
                                    modalElement.style.display = 'none';
                                    modalElement.classList.remove('show');
                                    document.body.classList.remove('modal-open');
                                    
                                    console.log('Mobile modal closed by backdrop');
                                }
                            });
                            
                            // Make form inputs work properly
                            setTimeout(() => {
                                const inputs = modalElement.querySelectorAll('input, textarea, select');
                                inputs.forEach(input => {
                                    input.readOnly = false;
                                    input.disabled = false;
                                    input.style.pointerEvents = 'auto';
                                    input.style.userSelect = 'auto';
                                    input.style.webkitUserSelect = 'auto';
                                });
                            }, 100);
                            
                            console.log('Mobile modal shown');
                        }
                    }
                }
            });
        });
        
        // Handle sidemenu navigation for mobile
        document.querySelectorAll('.sidebar .nav-link').forEach(link => {
            link.addEventListener('click', (e) => {
                console.log('Sidemenu link clicked:', link.href);
                
                // Close sidebar if it's open
                const sidebar = document.querySelector('.sidebar');
                if (sidebar && sidebar.classList.contains('show')) {
                    toggleSidebar();
                }
                
                // Allow navigation to proceed
                setTimeout(() => {
                    window.location.href = link.href;
                }, 100);
            });
        });
    }
    
            // Close sidebar when modal opens (mobile)
        document.querySelectorAll('.modal').forEach(modal => {
            modal.addEventListener('show.bs.modal', () => {
                if (window.innerWidth <= 767.98) {
                    const sidebar = document.querySelector('.sidebar');
                    if (sidebar.classList.contains('show')) {
                        toggleSidebar();
                    }
                    
                    // Force modal to be visible on mobile
                    setTimeout(() => {
                        modal.style.display = 'flex';
                        modal.style.alignItems = 'center';
                        modal.style.justifyContent = 'center';
                        modal.style.background = 'rgba(0,0,0,0.5)';
                        modal.style.zIndex = '9999';
                        
                        const dialog = modal.querySelector('.modal-dialog');
                        if (dialog) {
                            dialog.style.display = 'flex';
                            dialog.style.alignItems = 'center';
                            dialog.style.justifyContent = 'center';
                            dialog.style.margin = '10px';
                            dialog.style.maxWidth = 'calc(100% - 20px)';
                            dialog.style.width = '100%';
                        }
                        
                        const content = modal.querySelector('.modal-content');
                        if (content) {
                            content.style.background = 'white';
                            content.style.borderRadius = '12px';
                            content.style.boxShadow = '0 10px 30px rgba(0,0,0,0.3)';
                            content.style.maxHeight = '90vh';
                            content.style.overflowY = 'auto';
                            content.style.position = 'relative';
                            content.style.width = '100%';
                            content.style.zIndex = '10001';
                        }
                    }, 50);
                }
                
                // iOS Safari specific modal show handling
                if (/iPad|iPhone|iPod/.test(navigator.userAgent)) {
                    modal.style.webkitTransform = 'translateZ(0)';
                    modal.style.transform = 'translateZ(0)';
                    modal.style.webkitOverflowScrolling = 'touch';
                }
            });
            
            // Fix freeze issue when modal closes
            modal.addEventListener('hidden.bs.modal', () => {
                // Use global cleanup function
                window.cleanupModal();
            });
            
            // Also handle modal close buttons
            modal.querySelectorAll('[data-bs-dismiss="modal"]').forEach(closeButton => {
                closeButton.addEventListener('click', () => {
                    // Ensure cleanup happens immediately
                    setTimeout(() => {
                        window.cleanupModal();
                    }, 100);
                });
            });
            
            // iOS Safari touch event handling
            if (/iPad|iPhone|iPod/.test(navigator.userAgent)) {
                modal.addEventListener('touchstart', (e) => {
                    e.stopPropagation();
                }, { passive: true });
                
                modal.addEventListener('touchmove', (e) => {
                    e.stopPropagation();
                }, { passive: true });
            }
        });
        
        // Additional mobile modal fix
        if (isMobile) {
            // Override Bootstrap modal show event
            document.addEventListener('show.bs.modal', (e) => {
                const modal = e.target;
                if (window.innerWidth <= 767.98) {
                    // Force modal to be visible
                    setTimeout(() => {
                        modal.style.display = 'flex';
                        modal.style.alignItems = 'center';
                        modal.style.justifyContent = 'center';
                        modal.style.background = 'rgba(0,0,0,0.5)';
                        modal.style.zIndex = '9999';
                        
                        // Hide Bootstrap backdrop
                        const backdrop = document.querySelector('.modal-backdrop');
                        if (backdrop) {
                            backdrop.style.display = 'none';
                        }
                    }, 10);
                }
            });
        }
});
</script>
</body>
</html> 