<?php
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if user is logged in
if (!isset($_SESSION['user_logged_in'])) {
    // Determine the correct path to login.php based on current directory
    $current_dir = dirname($_SERVER['SCRIPT_NAME']);
    if (strpos($current_dir, '/admin') !== false) {
        header('Location: ../login.php');
    } else {
        header('Location: login.php');
    }
    exit;
}

include __DIR__ . '/db.php';

// Get shop info
$shop = $conn->query("SELECT * FROM shop_info WHERE id=1")->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="format-detection" content="telephone=no">
    <title><?= $page_title ?? 'Sistem Tempahan' ?> - <?= htmlspecialchars($shop['shop_name']) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body { background: #f8f9fa; }
        .sidebar { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; min-height: 100vh; }
        .main-content { min-height: 100vh; padding: 20px; }
        .card { border: none; box-shadow: 0 2px 8px rgba(0,0,0,0.1); border-radius: 12px; }
        .card-header { background: linear-gradient(45deg, #007bff, #0056b3); color: white; border-radius: 12px 12px 0 0 !important; border: none; }
        .nav-link { border-radius: 8px; margin-bottom: 4px; transition: all 0.3s ease; color: rgba(255,255,255,0.8); }
        .nav-link:hover { background: rgba(255,255,255,0.1); transform: translateX(5px); color: white; }
        .nav-link.active { background: rgba(255,255,255,0.2); color: white !important; }
        .form-control, .form-select { border-radius: 8px; border: 1px solid #dee2e6; }
        .form-control:focus, .form-select:focus { border-color: #007bff; box-shadow: 0 0 0 0.2rem rgba(0,123,255,0.25); }
        .btn-modern { border-radius: 8px; padding: 8px 16px; font-weight: 500; transition: all 0.3s ease; }
        .btn-modern:hover { transform: translateY(-2px); box-shadow: 0 4px 12px rgba(0,0,0,0.15); }
        
        /* Table styling */
        .table th { 
            background: #343a40 !important; 
            color: white !important;
            border-top: none; 
            font-weight: 600; 
        }
        
        .table-dark th {
            background: #212529 !important;
            color: white !important;
        }
        
        .table-light th {
            background: #6c757d !important;
            color: white !important;
        }
        
        /* Enhanced responsive sidebar */
        @media (max-width: 767.98px) {
            /* Global modal fix - ensure modals are not constrained by any parent */
            .modal {
                position: fixed !important;
                top: 0 !important;
                left: 0 !important;
                width: 100vw !important;
                height: 100vh !important;
                z-index: 9999 !important;
                transform: none !important;
                overflow: visible !important;
            }
            
                            /* Override any parent container constraints */
                * .modal {
                    position: fixed !important;
                    top: 0 !important;
                    left: 0 !important;
                    width: 100vw !important;
                    height: 100vh !important;
                    z-index: 9999 !important;
                    transform: none !important;
                    overflow: visible !important;
                }
                
                /* Portrait mode specific adjustments */
                @media (orientation: portrait) {
                    .modal.show .modal-dialog {
                        margin: 2px 10px 15px 10px !important;
                        max-width: calc(100vw - 20px) !important;
                        padding-top: 0vh !important;
                    }
                    
                    .modal.show .modal-content {
                        max-height: 70vh !important;
                    }
                    
                    .modal .modal-body {
                        padding: 12px 16px 20px 16px !important;
                        max-height: calc(70vh - 100px) !important;
                    }
                    
                    .modal .modal-footer {
                        padding: 12px 16px !important;
                        margin-top: 10px !important;
                    }
                }
            .sidebar {
                position: fixed;
                top: 0;
                left: -100%;
                height: 100vh;
                z-index: 1030;
                transition: left 0.3s ease;
                width: 280px;
                overflow-y: auto;
            }
            
            .sidebar.show {
                left: 0;
            }
            
            .main-content {
                margin-left: 0 !important;
                width: 100% !important;
            }
            
            .sidebar-overlay {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: rgba(0,0,0,0.5);
                z-index: 1020;
                display: none;
                opacity: 0;
                transition: opacity 0.3s ease;
            }
            
            /* Mobile Modal Fixes */
            .modal {
                position: fixed !important;
                top: 0 !important;
                left: 0 !important;
                width: 100vw !important;
                height: 100vh !important;
                z-index: 1055 !important;
                display: none;
                background: rgba(0,0,0,0.5) !important;
                align-items: center !important;
                justify-content: center !important;
                transform: none !important;
                overflow: visible !important;
            }
            
            .modal.show {
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                background: rgba(0,0,0,0.5) !important;
            }
            
            .modal-dialog {
                margin: 10px !important;
                max-width: calc(100% - 20px) !important;
                width: 100% !important;
                max-height: calc(100% - 20px) !important;
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
            }
            
            .modal-content {
                background: white !important;
                border-radius: 12px !important;
                box-shadow: 0 10px 30px rgba(0,0,0,0.3) !important;
                max-height: 90vh !important;
                overflow-y: auto !important;
                position: relative !important;
                width: 100% !important;
                z-index: 10001 !important;
            }
            
            .modal-header {
                border-bottom: 1px solid #dee2e6 !important;
                padding: 15px 20px !important;
            }
            
            .modal-body {
                padding: 20px !important;
            }
            
            .modal-footer {
                border-top: 1px solid #dee2e6 !important;
                padding: 15px 20px !important;
            }
            
            .modal .btn {
                min-height: 44px !important;
                padding: 10px 20px !important;
                font-size: 16px !important;
                border-radius: 8px !important;
            }
            
            .modal .form-control,
            .modal .form-select {
                min-height: 44px !important;
                font-size: 16px !important;
                padding: 10px 12px !important;
            }
            
            /* Hide Bootstrap backdrop on mobile */
            .modal-backdrop {
                display: none !important;
            }
            
            /* Ensure modal is above everything */
            .modal.show {
                z-index: 9999 !important;
            }
            
            /* Fix for iOS Safari */
            @supports (-webkit-touch-callout: none) {
                .modal {
                    padding-top: env(safe-area-inset-top) !important;
                    padding-bottom: env(safe-area-inset-bottom) !important;
                }
                
                .modal-content {
                    margin-top: env(safe-area-inset-top) !important;
                    margin-bottom: env(safe-area-inset-bottom) !important;
                }
            }
            
            .sidebar-overlay.show {
                display: block;
                opacity: 1;
            }
        }
        
        .menu-toggle {
            display: none;
            position: fixed;
            top: 8px;
            left: 8px;
            z-index: 1040;
            background: #007bff;
            border: none;
            color: white;
            width: 36px;
            height: 36px;
            border-radius: 6px;
            font-size: 1.1rem;
            box-shadow: 0 2px 6px rgba(0,0,0,0.15);
            transition: all 0.2s ease;
            align-items: center;
            justify-content: center;
        }
        
        .menu-toggle:hover {
            background: #0056b3;
            transform: scale(1.02);
            box-shadow: 0 3px 8px rgba(0,0,0,0.2);
        }
        
        .menu-toggle.hidden {
            opacity: 0;
            pointer-events: none;
        }
        
        @media (max-width: 767.98px) {
            .menu-toggle {
                display: flex;
            }
        }
        
        body.sidebar-open {
            overflow: hidden;
        }
        
        /* Prevent body freeze after modal closes */
        body:not(.sidebar-open) {
            overflow: auto !important;
        }
        
        html {
            overflow-x: hidden;
        }
        
        /* Ensure modals work properly on mobile */
        .modal {
            z-index: 1055 !important;
            -webkit-overflow-scrolling: touch;
        }
        
        .modal-backdrop {
            z-index: 1054 !important;
        }
        
        /* iOS Safari specific fixes */
        @supports (-webkit-touch-callout: none) {
            .modal {
                -webkit-transform: translateZ(0);
                transform: translateZ(0);
            }
            
            .modal-dialog {
                -webkit-transform: translateZ(0);
                transform: translateZ(0);
            }
            
            .modal-content {
                -webkit-transform: translateZ(0);
                transform: translateZ(0);
            }
            
            body {
                -webkit-overflow-scrolling: touch;
            }
        }
        
        /* Override Bootstrap modal transforms that might hide content */
        .modal.fade .modal-dialog {
            -webkit-transform: translateZ(0) !important;
            transform: translateZ(0) !important;
        }
        
        .modal.show .modal-dialog {
            -webkit-transform: translateZ(0) !important;
            transform: translateZ(0) !important;
        }
        
        /* Disable Bootstrap fade animation on mobile */
        @media (max-width: 767.98px) {
            .modal.fade .modal-dialog {
                transition: none !important;
                -webkit-transition: none !important;
            }
            
            .modal.show .modal-dialog {
                transition: none !important;
                -webkit-transition: none !important;
            }
            
            .modal.fade {
                transition: none !important;
                -webkit-transition: none !important;
            }
            
            /* Force modal visibility on mobile */
            .modal {
                display: none !important;
            }
            
            .modal.show {
                display: block !important;
                position: fixed !important;
                top: 0 !important;
                left: 0 !important;
                width: 100% !important;
                height: 100% !important;
                z-index: 1055 !important;
                background: rgba(0,0,0,0.5) !important;
                overflow: auto !important;
            }
            
            .modal.show .modal-dialog {
                display: block !important;
                position: relative !important;
                margin: 20px auto !important;
                max-width: 95% !important;
                width: 95% !important;
                transform: none !important;
                opacity: 1 !important;
                visibility: visible !important;
            }
            
            .modal.show .modal-content {
                display: block !important;
                background: white !important;
                color: black !important;
                border-radius: 12px !important;
                box-shadow: 0 5px 15px rgba(0,0,0,0.5) !important;
                opacity: 1 !important;
                visibility: visible !important;
            }
        }
        
        /* Prevent sidebar from interfering with modals */
        .sidebar.show + .modal-backdrop {
            z-index: 1054 !important;
        }
        
        .sidebar.show ~ .modal {
            z-index: 1055 !important;
        }
        
        /* Ensure modal is not hidden by any parent */
        .modal {
            position: fixed !important;
            z-index: 1055 !important;
        }
        
        /* Override any parent overflow hidden */
        body, html, .main-content, .container, .row, .col {
            overflow: visible !important;
        }
        
        /* Ensure body is scrollable after modal closes */
        body:not(.sidebar-open):not(.modal-open) {
            overflow: auto !important;
            position: static !important;
            top: auto !important;
            padding-right: 0 !important;
        }
        
        html:not(.modal-open) {
            overflow: auto !important;
            padding-right: 0 !important;
        }
        
        /* Force body to be scrollable on mobile */
        @media (max-width: 767.98px) {
            body {
                overflow: auto !important;
                position: static !important;
                top: auto !important;
                padding-right: 0 !important;
            }
            
            html {
                overflow: auto !important;
                padding-right: 0 !important;
            }
        }
        
        /* Mobile modal backdrop */
        .mobile-modal-backdrop {
            position: fixed !important;
            top: 0 !important;
            left: 0 !important;
            width: 100vw !important;
            height: 100vh !important;
            background-color: rgba(0, 0, 0, 0.6) !important;
            z-index: 9999 !important;
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
            padding: 20px !important;
            pointer-events: auto !important;
        }
        
        /* Ensure modal content is interactive */
        .mobile-modal-backdrop > * {
            pointer-events: auto !important;
            position: relative !important;
            z-index: 10000 !important;
        }
        
        /* Ensure form elements are above backdrop */
        .mobile-modal-backdrop form {
            pointer-events: auto !important;
            position: relative !important;
            z-index: 10001 !important;
        }
        
        .mobile-modal-backdrop .modal-body {
            pointer-events: auto !important;
            position: relative !important;
            z-index: 10001 !important;
        }
        
        /* Hide backdrop when removed */
        .mobile-modal-backdrop.removing {
            opacity: 0 !important;
            visibility: hidden !important;
            pointer-events: none !important;
        }
        
        /* Simple mobile modal approach */
        @media (max-width: 767.98px) {
            .modal:not(.show) {
                display: none !important;
                visibility: hidden !important;
                opacity: 0 !important;
                pointer-events: none !important;
            }
            
            .modal.show {
                display: block !important;
                position: fixed !important;
                top: 0 !important;
                left: 0 !important;
                width: 100% !important;
                height: 100% !important;
                z-index: 1055 !important;
                background: rgba(0,0,0,0.5) !important;
                overflow: auto !important;
                padding: 20px !important;
            }
            
            .modal.show .modal-dialog {
                display: block !important;
                position: relative !important;
                margin: 0 auto !important;
                max-width: 100% !important;
                width: 100% !important;
                transform: none !important;
                opacity: 1 !important;
                visibility: visible !important;
                height: auto !important;
                min-height: auto !important;
            }
            
            .modal.show .modal-content {
                display: block !important;
                background: white !important;
                color: black !important;
                border-radius: 12px !important;
                box-shadow: 0 5px 15px rgba(0,0,0,0.5) !important;
                opacity: 1 !important;
                visibility: visible !important;
                border: none !important;
                margin: 0 !important;
                padding: 0 !important;
            }
            
            .modal.show .modal-header {
                padding: 15px 20px !important;
                border-bottom: 1px solid #dee2e6 !important;
            }
            
            .modal.show .modal-body {
                padding: 20px !important;
                max-height: 70vh !important;
                overflow-y: auto !important;
            }
            
            .modal.show .modal-footer {
                padding: 15px 20px !important;
                border-top: 1px solid #dee2e6 !important;
            }
            
            /* Ensure form inputs work on mobile */
            .modal.show input,
            .modal.show textarea,
            .modal.show select {
                pointer-events: auto !important;
                user-select: auto !important;
                -webkit-user-select: auto !important;
                background: white !important;
                color: black !important;
                border: 1px solid #ced4da !important;
                padding: 10px 12px !important;
                cursor: text !important;
                opacity: 1 !important;
                visibility: visible !important;
                position: relative !important;
                z-index: 10001 !important;
                font-size: 16px !important; /* Prevent zoom on iOS */
                border-radius: 6px !important;
                margin-bottom: 10px !important;
            }
            
            .modal.show input:focus,
            .modal.show textarea:focus,
            .modal.show select:focus {
                border-color: #007bff !important;
                box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25) !important;
                outline: none !important;
            }
            
            .modal.show .btn {
                padding: 10px 20px !important;
                font-size: 16px !important;
                border-radius: 6px !important;
                margin: 5px !important;
            }
            
            .modal.show .form-label {
                font-size: 14px !important;
                font-weight: 600 !important;
                margin-bottom: 5px !important;
                color: #333 !important;
            }
        }
        
        /* Ensure mobile modal content is visible */
        .mobile-modal-backdrop > * {
            background: white !important;
            color: black !important;
            border-radius: 12px !important;
            max-width: 98% !important;
            width: 100% !important;
            max-height: 85vh !important;
            overflow-y: auto !important;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3) !important;
            position: relative !important;
            font-size: 14px !important;
        }
        
        /* Mobile modal scrollbar styling */
        .mobile-modal-backdrop ::-webkit-scrollbar {
            width: 6px !important;
        }
        
        .mobile-modal-backdrop ::-webkit-scrollbar-track {
            background: #f1f1f1 !important;
            border-radius: 3px !important;
        }
        
        .mobile-modal-backdrop ::-webkit-scrollbar-thumb {
            background: #c1c1c1 !important;
            border-radius: 3px !important;
        }
        
        .mobile-modal-backdrop ::-webkit-scrollbar-thumb:hover {
            background: #a8a8a8 !important;
        }
        
        /* Mobile modal improvements */
        @media (max-width: 767.98px) {
            .modal-dialog {
                margin: 10px;
                max-width: calc(100% - 20px);
                -webkit-transform: translateZ(0);
                transform: translateZ(0);
            }
            
            /* Force modal-lg to be responsive on mobile */
            .modal-dialog.modal-lg {
                max-width: calc(100% - 20px) !important;
                width: calc(100% - 20px) !important;
                margin: 10px !important;
            }
            
            .modal-content {
                border-radius: 12px;
                -webkit-transform: translateZ(0);
                transform: translateZ(0);
            }
            
            .modal-header {
                border-radius: 12px 12px 0 0;
            }
            
            .modal-footer {
                border-radius: 0 0 12px 12px;
            }
            
            /* Ensure modal buttons are touch-friendly */
            .modal .btn {
                min-height: 44px;
                padding: 10px 16px;
                font-size: 16px;
                -webkit-appearance: none;
                -webkit-tap-highlight-color: transparent;
                position: relative;
                z-index: 1;
            }
            
            /* Ensure form inputs are touch-friendly */
            .modal input, .modal textarea, .modal select {
                min-height: 44px;
                font-size: 16px;
                -webkit-appearance: none;
                border-radius: 8px;
            }
            
            /* Mobile modal form elements */
            .mobile-modal-backdrop input,
            .mobile-modal-backdrop textarea,
            .mobile-modal-backdrop select,
            .mobile-modal-backdrop button {
                min-height: 40px !important;
                font-size: 14px !important;
                -webkit-appearance: none !important;
                border-radius: 6px !important;
                margin-bottom: 8px !important;
                padding: 8px 12px !important;
            }
            
            .mobile-modal-backdrop button {
                padding: 10px 16px !important;
                font-weight: 500 !important;
                font-size: 14px !important;
                cursor: pointer !important;
                border: none !important;
                border-radius: 6px !important;
                transition: all 0.2s !important;
            }
            
            /* Ensure inputs are interactive */
            .mobile-modal-backdrop input:not([type="submit"]):not([type="button"]),
            .mobile-modal-backdrop textarea,
            .mobile-modal-backdrop select {
                background: white !important;
                color: black !important;
                border: 1px solid #ced4da !important;
                padding: 8px 12px !important;
                pointer-events: auto !important;
                cursor: text !important;
                user-select: auto !important;
                -webkit-user-select: auto !important;
                -moz-user-select: auto !important;
                -ms-user-select: auto !important;
                opacity: 1 !important;
                visibility: visible !important;
                position: relative !important;
                z-index: 10001 !important;
                -webkit-touch-callout: default !important;
                -webkit-tap-highlight-color: rgba(0,0,0,0.1) !important;
            }
            
            /* Force input interaction */
            .mobile-modal-backdrop input[type="text"],
            .mobile-modal-backdrop input[type="number"],
            .mobile-modal-backdrop input[type="date"],
            .mobile-modal-backdrop input[type="email"],
            .mobile-modal-backdrop input[type="tel"],
            .mobile-modal-backdrop textarea,
            .mobile-modal-backdrop select {
                pointer-events: auto !important;
                touch-action: manipulation !important;
                -webkit-touch-callout: default !important;
                -webkit-tap-highlight-color: rgba(0,0,0,0.1) !important;
            }
            
            .mobile-modal-backdrop input:focus,
            .mobile-modal-backdrop textarea:focus,
            .mobile-modal-backdrop select:focus {
                border-color: #007bff !important;
                box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25) !important;
                outline: none !important;
            }
            
            .mobile-modal-backdrop button:hover {
                opacity: 0.8 !important;
                transform: translateY(-1px) !important;
            }
            
            .mobile-modal-backdrop button:active {
                transform: translateY(0) !important;
            }
            
            /* Mobile modal typography */
            .mobile-modal-backdrop h5 {
                font-size: 18px !important;
                font-weight: 600 !important;
                margin-bottom: 15px !important;
            }
            
            .mobile-modal-backdrop label {
                font-size: 13px !important;
                font-weight: 500 !important;
                margin-bottom: 5px !important;
                color: #333 !important;
            }
            
            .mobile-modal-backdrop .form-label {
                font-size: 13px !important;
                font-weight: 500 !important;
                margin-bottom: 5px !important;
                color: #333 !important;
            }
            
            /* Mobile modal spacing */
            .mobile-modal-backdrop .row {
                margin-left: -5px !important;
                margin-right: -5px !important;
            }
            
            .mobile-modal-backdrop .col-md-3,
            .mobile-modal-backdrop .col-md-6 {
                padding-left: 5px !important;
                padding-right: 5px !important;
            }
            
            .mobile-modal-backdrop .mb-3 {
                margin-bottom: 10px !important;
            }
            
            /* Compact form layout for mobile */
            .mobile-modal-backdrop .row {
                margin-bottom: 8px !important;
            }
            
            .mobile-modal-backdrop .col-md-3,
            .mobile-modal-backdrop .col-md-6 {
                margin-bottom: 8px !important;
            }
            
            /* Smaller textarea for mobile */
            .mobile-modal-backdrop textarea {
                min-height: 60px !important;
                resize: vertical !important;
            }
            
            /* Better button styling */
            .mobile-modal-backdrop .btn {
                border-radius: 6px !important;
                font-weight: 500 !important;
                text-transform: none !important;
            }
            
            .mobile-modal-backdrop .btn-primary {
                background-color: #007bff !important;
                border-color: #007bff !important;
            }
            
            .mobile-modal-backdrop .btn-secondary {
                background-color: #6c757d !important;
                border-color: #6c757d !important;
            }
            
            /* Mobile modal header and footer */
            .mobile-modal-backdrop .modal-header {
                padding: 15px 20px !important;
                border-bottom: 1px solid #dee2e6 !important;
                display: block !important;
                visibility: visible !important;
            }
            
            .mobile-modal-backdrop .modal-body {
                padding: 15px 20px !important;
                display: block !important;
                visibility: visible !important;
            }
            
            .mobile-modal-backdrop .modal-footer {
                padding: 15px 20px !important;
                border-top: 1px solid #dee2e6 !important;
                display: flex !important;
                visibility: visible !important;
                gap: 10px !important;
                justify-content: flex-end !important;
            }
            
            /* Ensure footer buttons are visible */
            .mobile-modal-backdrop .modal-footer button {
                display: inline-block !important;
                visibility: visible !important;
                opacity: 1 !important;
                min-width: 80px !important;
            }
            
            /* Force modal to be visible */
            .modal.show {
                display: block !important;
                background: rgba(0,0,0,0.5) !important;
                -webkit-transform: translateZ(0);
                transform: translateZ(0);
                position: fixed !important;
                top: 0 !important;
                left: 0 !important;
                right: 0 !important;
                bottom: 0 !important;
                z-index: 1055 !important;
            }
            
            /* Ensure modal content is visible */
            .modal.show .modal-dialog {
                display: flex !important;
                opacity: 1 !important;
                visibility: visible !important;
                -webkit-transform: translateZ(0) !important;
                transform: translateZ(0) !important;
                align-items: center !important;
                justify-content: center !important;
            }
            
            .modal.show .modal-content {
                display: block !important;
                opacity: 1 !important;
                visibility: visible !important;
                background: white !important;
                color: black !important;
                position: relative !important;
                z-index: 10000 !important;
            }
            
            .modal-backdrop.show {
                opacity: 0.5 !important;
                position: fixed !important;
                top: 0 !important;
                left: 0 !important;
                right: 0 !important;
                bottom: 0 !important;
                z-index: 1054 !important;
            }
            
            /* Prevent body freeze */
            body.modal-open {
                overflow: auto !important;
                position: static !important;
                padding-right: 0 !important;
                -webkit-overflow-scrolling: touch;
            }
            
            /* Ensure page remains scrollable */
            html.modal-open {
                overflow: auto !important;
                padding-right: 0 !important;
            }
            
            /* iPhone specific fixes */
            @supports (-webkit-touch-callout: none) {
                .modal-dialog {
                    margin: 20px 15px;
                    max-width: calc(100% - 30px);
                }
                
                .modal .btn {
                    min-height: 36px;
                    padding: 8px 16px;
                    font-size: 14px;
                }
                
                /* Fix for iPhone notch */
                .modal {
                    padding-top: env(safe-area-inset-top);
                    padding-bottom: env(safe-area-inset-bottom);
                }
            }
            
                                /* Force modal visibility on mobile */
            @media (max-width: 767.98px) {
                /* Ensure modal is positioned correctly regardless of parent container */
                .modal {
                    position: fixed !important;
                    top: 0 !important;
                    left: 0 !important;
                    width: 100vw !important;
                    height: 100vh !important;
                    z-index: 9999 !important;
                    display: none;
                    background: rgba(0,0,0,0.5) !important;
                    align-items: center !important;
                    justify-content: center !important;
                }
                
                .modal.show {
                    display: flex !important;
                    align-items: center !important;
                    justify-content: center !important;
                    background: rgba(0,0,0,0.5) !important;
                }
                
                .modal.show .modal-dialog {
                    display: flex !important;
                    align-items: flex-start !important;
                    justify-content: center !important;
                    margin: 5px 15px 20px 15px !important;
                    max-width: calc(100vw - 30px) !important;
                    width: 100% !important;
                    position: relative !important;
                    z-index: 10000 !important;
                    padding-top: 2vh !important;
                }
                
                .modal.show .modal-content {
                    background: white !important;
                    border-radius: 8px !important;
                    box-shadow: 0 8px 25px rgba(0,0,0,0.3) !important;
                    max-height: 75vh !important;
                    overflow-y: auto !important;
                    position: relative !important;
                    width: 100% !important;
                    z-index: 10001 !important;
                }
                
                /* Hide Bootstrap backdrop on mobile */
                .modal-backdrop {
                    display: none !important;
                }
                
                /* Ensure form inputs are editable */
                .modal input,
                .modal textarea,
                .modal select {
                    pointer-events: auto !important;
                    user-select: auto !important;
                    -webkit-user-select: auto !important;
                    -moz-user-select: auto !important;
                    -ms-user-select: auto !important;
                    background: white !important;
                    color: black !important;
                    border: 1px solid #ced4da !important;
                    padding: 6px 10px !important;
                    cursor: text !important;
                    opacity: 1 !important;
                    visibility: visible !important;
                    position: relative !important;
                    z-index: 10002 !important;
                    font-size: 14px !important;
                    min-height: 36px !important;
                }
                
                /* Smaller font sizes for mobile modal */
                .modal .form-label {
                    font-size: 13px !important;
                    font-weight: 500 !important;
                    margin-bottom: 5px !important;
                }
                
                .modal .modal-header h5 {
                    font-size: 16px !important;
                    font-weight: 600 !important;
                    margin: 0 !important;
                }
                
                .modal .modal-body {
                    padding: 12px 16px 20px 16px !important;
                    max-height: calc(75vh - 100px) !important;
                    overflow-y: auto !important;
                }
                
                .modal .modal-header {
                    padding: 10px 16px !important;
                }
                
                .modal .modal-footer {
                    padding: 10px 16px !important;
                    position: sticky !important;
                    bottom: 0 !important;
                    background: white !important;
                    border-top: 1px solid #dee2e6 !important;
                    z-index: 10003 !important;
                    margin-top: 10px !important;
                }
                
                .modal .btn {
                    font-size: 13px !important;
                    padding: 6px 12px !important;
                    min-height: 36px !important;
                    margin: 2px !important;
                }
                
                /* Ensure footer buttons are always visible */
                .modal .modal-footer .btn {
                    min-width: 80px !important;
                    margin: 0 5px !important;
                    display: inline-block !important;
                    visibility: visible !important;
                    opacity: 1 !important;
                }
                
                /* Ensure modal footer is always at bottom */
                .modal .modal-footer {
                    position: sticky !important;
                    bottom: 0 !important;
                    background: white !important;
                    border-top: 1px solid #dee2e6 !important;
                    z-index: 10003 !important;
                    margin-top: 10px !important;
                    box-shadow: 0 -2px 10px rgba(0,0,0,0.1) !important;
                }
                
                /* Smaller spacing for form groups */
                .modal .mb-3 {
                    margin-bottom: 10px !important;
                }
                
                .modal .row {
                    margin-left: -5px !important;
                    margin-right: -5px !important;
                }
                
                .modal .col-md-3,
                .modal .col-md-6 {
                    padding-left: 5px !important;
                    padding-right: 5px !important;
                }
                
                /* Prevent body freeze */
                body.modal-open {
                    overflow: auto !important;
                    position: static !important;
                    padding-right: 0 !important;
                    -webkit-overflow-scrolling: touch;
                }
                
                /* Ensure page remains scrollable */
                html.modal-open {
                    overflow: auto !important;
                    padding-right: 0 !important;
                }
                
                /* Override any table container constraints */
                .table-responsive .modal,
                .card .modal,
                .container .modal,
                .row .modal,
                tbody .modal,
                tr .modal,
                td .modal {
                    position: fixed !important;
                    top: 0 !important;
                    left: 0 !important;
                    width: 100vw !important;
                    height: 100vh !important;
                    z-index: 9999 !important;
                    transform: none !important;
                    overflow: visible !important;
                }
                
                /* Ensure modal is always on top regardless of parent */
                .modal {
                    position: fixed !important;
                    top: 0 !important;
                    left: 0 !important;
                    width: 100vw !important;
                    height: 100vh !important;
                    z-index: 9999 !important;
                    transform: none !important;
                    overflow: visible !important;
                }
            }
        }
        
        /* User name styling - always single line */
        .user-name {
            font-size: 0.85rem;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            max-width: 100%;
            display: block;
            line-height: 1.2;
        }
        
        /* Responsive font size for user name */
        @media (max-width: 767.98px) {
            .user-name {
                font-size: 0.8rem;
            }
        }
        
        @media (max-width: 575.98px) {
            .user-name {
                font-size: 0.75rem;
            }
        }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row"> 
            <!-- Mobile Menu Toggle -->
            <button class="menu-toggle" onclick="toggleSidebar()" title="Buka Menu">
                <i class="bi bi-grid-3x3-gap"></i>
            </button>
            
            <!-- Sidebar Overlay -->
            <div class="sidebar-overlay" onclick="toggleSidebar()"></div>
            
            <!-- Sidebar -->
            <?php include __DIR__ . '/sidemenu.php'; ?> 