<div class="sidebar col-md-3 col-lg-2 d-md-block">
    <div class="p-3">
        <!-- Compact Header Section -->
        <div class="text-center mb-3">
            <?php if ($shop['logo_image']): ?>
                <img src="/eoderalh/uploads/<?= htmlspecialchars($shop['logo_image']) ?>" alt="Logo" style="max-width: 80px; max-height: 60px; margin-bottom: 8px;">
            <?php endif; ?>
            <h6 class="mb-1" style="font-size: 0.9rem; font-weight: 600;"><?= htmlspecialchars($shop['shop_name']) ?></h6>
            <small class="opacity-75" style="font-size: 0.75rem;">Sistem Tempahan</small>
        </div>
        
        <!-- Compact User Info Section -->
        <div class="text-center mb-3 p-2" style="background: rgba(255,255,255,0.1); border-radius: 8px;">
            <div class="d-flex align-items-center justify-content-center mb-1">
                <i class="bi bi-person-circle me-2" style="font-size: 1.2rem;"></i>
                <span class="badge bg-<?= $_SESSION['user_peranan'] === 'Admin' ? 'danger' : ($_SESSION['user_peranan'] === 'Pengurus' ? 'warning' : 'success') ?>" style="font-size: 0.7rem;">
                    <?= $_SESSION['user_peranan'] ?>
                </span>
            </div>
            <div class="user-name" style="font-size: 0.8rem; font-weight: 500; line-height: 1.2;">
                <?= htmlspecialchars($_SESSION['realname']) ?>
            </div>
        </div>
        
        <hr class="my-2" style="opacity: 0.3;">
        
        <nav class="nav flex-column">
            <!-- Dashboard - Admin only -->
            <?php if ($_SESSION['user_peranan'] === 'Admin'): ?>
            <a class="nav-link <?= $current_page === 'dashboard' ? 'active' : '' ?>" href="/eoderalh/admin/index.php" style="padding: 0.5rem 0.75rem; font-size: 0.85rem;">
                <i class="bi bi-house-door me-2"></i> Dashboard
            </a>
            <?php endif; ?>
            
            <!-- Senarai Tempahan - All users -->
            <a class="nav-link <?= $current_page === 'orders' ? 'active' : '' ?>" href="/eoderalh/index.php" style="padding: 0.5rem 0.75rem; font-size: 0.85rem;">
                <i class="bi bi-list-ul me-2"></i> Senarai Tempahan
            </a>
            
            <!-- Tambah Tempahan - All users -->
            <a class="nav-link <?= $current_page === 'add_order' ? 'active' : '' ?>" href="/eoderalh/tempahan.php" style="padding: 0.5rem 0.75rem; font-size: 0.85rem;">
                <i class="bi bi-plus-circle me-2"></i> Tambah Tempahan
            </a>
            
            <!-- Pengurusan Pelanggan - All users -->
            <a class="nav-link <?= $current_page === 'customers' ? 'active' : '' ?>" href="/eoderalh/admin/customers.php" style="padding: 0.5rem 0.75rem; font-size: 0.85rem;">
                <i class="bi bi-people me-2"></i> Pengurusan Pelanggan
            </a>
            
            <!-- Jualan Saya - All users -->
            <a class="nav-link <?= $current_page === 'my_sales' ? 'active' : '' ?>" href="/eoderalh/my_sales.php" style="padding: 0.5rem 0.75rem; font-size: 0.85rem;">
                <i class="bi bi-person-check me-2"></i> Jualan Saya
            </a>
            
            <!-- Urus Link Invoice - All users -->
            <a class="nav-link <?= $current_page === 'invoice_links' ? 'active' : '' ?>" href="/eoderalh/manage_invoice_links.php" style="padding: 0.5rem 0.75rem; font-size: 0.85rem;">
                <i class="bi bi-link-45deg me-2"></i> Urus Link Invoice
            </a>
            
            <!-- Admin only features -->
            <?php if ($_SESSION['user_peranan'] === 'Admin'): ?>
            <a class="nav-link <?= $current_page === 'analisis' ? 'active' : '' ?>" href="/eoderalh/admin/analisis.php" style="padding: 0.5rem 0.75rem; font-size: 0.85rem;">
                <i class="bi bi-graph-up me-2"></i> Analisis
            </a>
            <a class="nav-link <?= $current_page === 'users' ? 'active' : '' ?>" href="/eoderalh/admin/users.php" style="padding: 0.5rem 0.75rem; font-size: 0.85rem;">
                <i class="bi bi-person-gear me-2"></i> Pengurusan Pengguna
            </a>
            <a class="nav-link <?= $current_page === 'password' ? 'active' : '' ?>" href="/eoderalh/admin/password.php" style="padding: 0.5rem 0.75rem; font-size: 0.85rem;">
                <i class="bi bi-key me-2"></i> Tukar Password
            </a>
            <?php endif; ?>
        </nav>
        
        <hr class="my-2" style="opacity: 0.3;">
        
        <!-- Logout Section -->
        <div class="text-center">
            <a class="nav-link" href="/eoderalh/admin/logout.php" style="padding: 0.5rem 0.75rem; font-size: 0.85rem; color: rgba(255,255,255,0.8);">
                <i class="bi bi-box-arrow-right me-2"></i> Logout
            </a>
        </div>
    </div>
</div>

<!-- Main Content -->
<div class="main-content col-md-9 col-lg-10 ms-sm-auto px-md-4"> 