<?php
// Process form submissions BEFORE any output
if (isset($_POST['edit_order'])) {
    // Start session and connect to database
    session_start();
    include 'includes/db.php';
    
    $oid = (int)$_POST['order_id'];
    $customer_name = trim($_POST['customer_name']);
    $customer_phone = trim($_POST['customer_phone']);
    $customer_address = trim($_POST['customer_address']);
    $perkara = trim($_POST['perkara']);
    $order_date = $_POST['order_date'];
    $due_date = !empty($_POST['due_date']) ? $_POST['due_date'] : null;
    $collar_ss = (int)$_POST['collar_ss'];
    $collar_ls = (int)$_POST['collar_ls'];
    $rn_ss = (int)$_POST['rn_ss'];
    $rn_ls = (int)$_POST['rn_ls'];
    $muslimah = (int)$_POST['muslimah'];
    $nama_nombor = (int)$_POST['nama_nombor'];
    $kain_diamond = (int)$_POST['kain_diamond'];
    $shipping_cost = (float)$_POST['shipping_cost'];
    $discount = (float)$_POST['discount'];
    
    // Get prices
    $prices = [];
    $price_result = $conn->query("SELECT * FROM prices");
    while ($row = $price_result->fetch_assoc()) {
        $prices[$row['item_type']] = $row;
    }
    
    // Calculate totals
    $total_cost = ($collar_ss * $prices['collar_ss']['purchase_price']) + 
                  ($collar_ls * $prices['collar_ls']['purchase_price']) + 
                  ($rn_ss * $prices['rn_ss']['purchase_price']) + 
                  ($rn_ls * $prices['rn_ls']['purchase_price']) + 
                  ($muslimah * $prices['muslimah']['purchase_price']) +
                  ($nama_nombor * $prices['nama_nombor']['purchase_price']) +
                  ($kain_diamond * $prices['kain_diamond']['purchase_price']) +
                  $shipping_cost;
    
    $total_cost_price = $total_cost;
    
    $total_sale = ($collar_ss * $prices['collar_ss']['sale_price']) + 
                  ($collar_ls * $prices['collar_ls']['sale_price']) + 
                  ($rn_ss * $prices['rn_ss']['sale_price']) + 
                  ($rn_ls * $prices['rn_ls']['sale_price']) + 
                  ($muslimah * $prices['muslimah']['sale_price']) +
                  ($nama_nombor * $prices['nama_nombor']['sale_price']) +
                  ($kain_diamond * $prices['kain_diamond']['sale_price']) +
                  $shipping_cost - $discount;
    
    try {
        $stmt = $conn->prepare("UPDATE orders SET customer_name=?, customer_phone=?, customer_address=?, perkara=?, order_date=?, due_date=?, collar_ss=?, collar_ls=?, rn_ss=?, rn_ls=?, muslimah=?, nama_nombor=?, kain_diamond=?, shipping_cost=?, discount=?, total_cost=?, total_cost_price=?, total_sale=? WHERE id=?");
        
        if (!$stmt) {
            throw new Exception("Prepare failed: " . $conn->error);
        }
        
        $stmt->bind_param('ssssssiiiiiiidddddi', $customer_name, $customer_phone, $customer_address, $perkara, $order_date, $due_date, $collar_ss, $collar_ls, $rn_ss, $rn_ls, $muslimah, $nama_nombor, $kain_diamond, $shipping_cost, $discount, $total_cost, $total_cost_price, $total_sale, $oid);
        
        if (!$stmt->execute()) {
            throw new Exception("Execute failed: " . $stmt->error);
        }
        
        $stmt->close();
        
        // Success - redirect
        header('Location: index.php?update=1');
        exit;
        
    } catch (Exception $e) {
        // Log error
        error_log("Error in index.php edit: " . $e->getMessage());
        
        // Show error message instead of blank page
        $error_message = "Error: " . $e->getMessage();
    }
}

if (isset($_POST['delete_order'])) {
    // Start session and connect to database
    session_start();
    include 'includes/db.php';
    
    $oid = (int)$_POST['order_id'];
    
    try {
        $stmt = $conn->prepare("DELETE FROM orders WHERE id=?");
        
        if (!$stmt) {
            throw new Exception("Prepare failed: " . $conn->error);
        }
        
        $stmt->bind_param('i', $oid);
        
        if (!$stmt->execute()) {
            throw new Exception("Execute failed: " . $stmt->error);
        }
        
        $stmt->close();
        
        // Success - redirect
        header('Location: index.php?delete=1');
        exit;
        
    } catch (Exception $e) {
        // Log error
        error_log("Error in index.php delete: " . $e->getMessage());
        
        // Show error message instead of blank page
        $error_message = "Error: " . $e->getMessage();
    }
}

if (isset($_POST['update_status'])) {
    // Start session and connect to database
    session_start();
    include 'includes/db.php';
    
    $oid = (int)$_POST['order_id'];
    $status_order = $_POST['status_order'];
    $status_hantar = $_POST['status_hantar'];
    $status_bayar = $_POST['status_bayar'];
    $payment_method = $_POST['payment_method'] ?? null;
    $payment_date = $_POST['payment_date'] ?? null;
    
    try {
        // If status bayar is 'Belum', clear payment info
        if ($status_bayar === 'Belum') {
            $payment_method = null;
            $payment_date = null;
        }
        
        $stmt = $conn->prepare("UPDATE orders SET status_order=?, status_hantar=?, status_bayar=?, payment_method=?, payment_date=? WHERE id=?");
        
        if (!$stmt) {
            throw new Exception("Prepare failed: " . $conn->error);
        }
        
        $stmt->bind_param('sssssi', $status_order, $status_hantar, $status_bayar, $payment_method, $payment_date, $oid);
        
        if (!$stmt->execute()) {
            throw new Exception("Execute failed: " . $stmt->error);
        }
        
        $stmt->close();
        
        // Success - redirect
        header('Location: index.php?status=1');
        exit;
        
    } catch (Exception $e) {
        // Log error
        error_log("Error in index.php status update: " . $e->getMessage());
        
        // Show error message instead of blank page
        $error_message = "Error: " . $e->getMessage();
    }
}

// Set page variables for header
$page_title = 'Senarai Tempahan';
$page_subtitle = 'Senarai Tempahan';
$current_page = 'orders';
$base_path = '';

// Include header (includes session_start, db connection, and shop info)
include 'includes/header.php';
?>

<style>
/* Table sorting styles */
.sortable {
    cursor: pointer;
    user-select: none;
    position: relative;
}

.sortable:hover {
    background-color: rgba(255, 255, 255, 0.1);
}

.sortable::after {
    content: '↕';
    position: absolute;
    right: 8px;
    color: #adb5bd;
    font-size: 0.8rem;
}

.sortable.asc::after {
    content: '↑';
    color: #fff;
}

.sortable.desc::after {
    content: '↓';
    color: #fff;
}

/* Table improvements */
.table th {
    border-top: none;
    font-weight: 600;
    font-size: 0.9rem;
}

.table td {
    vertical-align: middle;
    font-size: 0.9rem;
}

/* Responsive table */
@media (max-width: 768px) {
    .table-responsive {
        font-size: 0.8rem;
    }
    
    .btn-group .btn {
        padding: 0.25rem 0.5rem;
        font-size: 0.75rem;
    }
}
</style>

<?php
// Get orders with user information
$orders = $conn->query("SELECT o.*, u.realname as user_name FROM orders o LEFT JOIN users u ON o.user_id = u.iduser ORDER BY o.order_date DESC");
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-list-ul"></i> Senarai Tempahan</h1>
    <a href="tempahan.php" class="btn btn-primary btn-modern">
        <i class="bi bi-plus-circle"></i> Tambah Tempahan Baru
    </a>
</div>

<?php if (isset($_GET['update'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle"></i> Tempahan berjaya dikemaskini!
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (isset($_GET['delete'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle"></i> Tempahan berjaya dipadam!
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (isset($_GET['status'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle"></i> Status tempahan berjaya dikemaskini!
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (isset($_GET['success'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle"></i> Tempahan berjaya ditambah!
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (isset($error_message)): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="bi bi-exclamation-triangle"></i> <?= htmlspecialchars($error_message) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-header">
        <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="bi bi-list-ul"></i> Senarai Tempahan</h5>
            <div class="d-flex align-items-center">
                <input type="text" id="searchInput" class="form-control form-control-sm me-2" placeholder="Cari tempahan..." style="width: 200px;">
                <span class="badge bg-secondary" id="resultCount"></span>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-dark">
                    <tr>
                        <th class="sortable" data-sort="bil">Bil</th>
                        <th class="sortable" data-sort="nama">Nama</th>
                        <th class="sortable" data-sort="notel">No Tel</th>
                        <th class="sortable" data-sort="tarikh">Tarikh Order</th>
                        <th class="sortable" data-sort="pengguna">Pengguna</th>
                        <th class="sortable" data-sort="jualan">Jualan (RM)</th>
                        <th class="sortable" data-sort="status">Status</th>
                        <th class="sortable" data-sort="payment">Pembayaran</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i=1; while($row = $orders->fetch_assoc()): ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= htmlspecialchars($row['customer_name']) ?></td>
                        <td><?= htmlspecialchars($row['customer_phone']) ?></td>
                        <td><?= $row['order_date'] ?></td>
                        <td>
                            <small class="text-muted"><?= htmlspecialchars($row['user_name'] ?? 'N/A') ?></small>
                        </td>
                        <td><?= number_format($row['total_sale'],2) ?></td>
                        <td>
                            <span class="badge bg-<?= $row['status_order']==='Siap'?'success':($row['status_order']==='Batal'?'danger':'secondary') ?>"><?= $row['status_order'] ?></span>
                            <span class="badge bg-<?= $row['status_hantar']==='Sudah'?'info':'secondary' ?>"><?= $row['status_hantar'] ?></span>
                            <span class="badge bg-<?= $row['status_bayar']==='Sudah'?'primary':'secondary' ?>"><?= $row['status_bayar'] ?></span>
                        </td>
                        <td>
                            <?php if ($row['status_bayar'] === 'Sudah' && $row['payment_method']): ?>
                                <div>
                                    <span class="badge bg-success">PAID</span>
                                    <br><small class="text-muted"><?= htmlspecialchars($row['payment_method']) ?></small>
                                    <?php if ($row['payment_date']): ?>
                                        <br><small class="text-muted"><?= date('d/m/Y', strtotime($row['payment_date'])) ?></small>
                                    <?php endif; ?>
                                </div>
                            <?php else: ?>
                                <span class="badge bg-secondary">UNPAID</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="invoice/invoice.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-success" target="_blank" title="Cetak Invoice">
                                    <i class="bi bi-printer"></i>
                                </a>
                                <button class="btn btn-sm btn-whatsapp" onclick="sendInvoiceWhatsApp(<?= $row['id'] ?>, '<?= htmlspecialchars($row['customer_phone']) ?>')" title="Hantar Invoice WhatsApp">
                                    <i class="bi bi-whatsapp"></i>
                                </button>
                                <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editModal<?= $row['id'] ?>" title="Edit Tempahan">
                                    <i class="bi bi-pencil"></i>
                                </button>
                                <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#statusModal<?= $row['id'] ?>" title="Kemaskini Status">
                                    <i class="bi bi-gear"></i>
                                </button>
                                <button class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteModal<?= $row['id'] ?>" title="Padam Tempahan">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    
                    <!-- Modal Edit Tempahan -->
                    <div class="modal fade" id="editModal<?= $row['id'] ?>" tabindex="-1">
                      <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                          <form method="post">
                          <div class="modal-header">
                            <h5 class="modal-title">Edit Tempahan #<?= $row['id'] ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                          </div>
                          <div class="modal-body">
                            <input type="hidden" name="order_id" value="<?= $row['id'] ?>">
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Nama Pelanggan</label>
                                    <input type="text" name="customer_name" class="form-control" value="<?= htmlspecialchars($row['customer_name']) ?>" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">No Tel</label>
                                    <input type="text" name="customer_phone" class="form-control" value="<?= htmlspecialchars($row['customer_phone']) ?>" required>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Alamat Pelanggan</label>
                                <textarea name="customer_address" class="form-control" rows="3" required><?= htmlspecialchars(str_replace(["\r\n", "\r", "\n"], "\n", $row['customer_address'])) ?></textarea>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Perkara</label>
                                <textarea name="perkara" class="form-control" rows="3" placeholder="Masukkan perkara atau butiran tempahan..."><?= htmlspecialchars($row['perkara']) ?></textarea>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Tarikh Order</label>
                                    <input type="date" name="order_date" class="form-control" value="<?= $row['order_date'] ?>" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Tarikh Siap</label>
                                    <input type="date" name="due_date" class="form-control" value="<?= $row['due_date'] ? $row['due_date'] : '' ?>">
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-3">
                                    <label class="form-label">Kolar SS</label>
                                    <input type="number" name="collar_ss" class="form-control" min="0" value="<?= isset($row['collar_ss']) ? $row['collar_ss'] : 0 ?>">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Kolar LS</label>
                                    <input type="number" name="collar_ls" class="form-control" min="0" value="<?= isset($row['collar_ls']) ? $row['collar_ls'] : 0 ?>">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">RN SS</label>
                                    <input type="number" name="rn_ss" class="form-control" min="0" value="<?= isset($row['rn_ss']) ? $row['rn_ss'] : 0 ?>">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">RN LS</label>
                                    <input type="number" name="rn_ls" class="form-control" min="0" value="<?= isset($row['rn_ls']) ? $row['rn_ls'] : 0 ?>">
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-3">
                                    <label class="form-label">Muslimah</label>
                                    <input type="number" name="muslimah" class="form-control" min="0" value="<?= isset($row['muslimah']) ? $row['muslimah'] : 0 ?>">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Nama/Nombor</label>
                                    <input type="number" name="nama_nombor" class="form-control" min="0" value="<?= isset($row['nama_nombor']) ? $row['nama_nombor'] : 0 ?>">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Kain Diamond</label>
                                    <input type="number" name="kain_diamond" class="form-control" min="0" value="<?= isset($row['kain_diamond']) ? $row['kain_diamond'] : 0 ?>">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Kos Pos (RM)</label>
                                    <input type="number" step="0.01" name="shipping_cost" class="form-control" min="0" value="<?= $row['shipping_cost'] ?>">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Diskaun (RM)</label>
                                    <input type="number" step="0.01" name="discount" class="form-control" min="0" value="<?= isset($row['discount']) ? $row['discount'] : 0 ?>">
                                </div>
                            </div>
                          </div>
                          <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                            <button type="submit" name="edit_order" class="btn btn-primary">Simpan Perubahan</button>
                          </div>
                          </form>
                        </div>
                      </div>
                    </div>
                    
                    <!-- Modal Status Tempahan -->
                    <div class="modal fade" id="statusModal<?= $row['id'] ?>" tabindex="-1">
                      <div class="modal-dialog">
                        <div class="modal-content">
                          <form method="post">
                          <div class="modal-header">
                            <h5 class="modal-title">Kemaskini Status Tempahan #<?= $row['id'] ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                          </div>
                          <div class="modal-body">
                            <input type="hidden" name="order_id" value="<?= $row['id'] ?>">
                            <div class="mb-3">
                                <label class="form-label">Status Order</label>
                                <select name="status_order" class="form-select">
                                    <option value="Dalam Proses" <?= $row['status_order']=='Dalam Proses'?'selected':'' ?>>Dalam Proses</option>
                                    <option value="Siap" <?= $row['status_order']=='Siap'?'selected':'' ?>>Siap</option>
                                    <option value="Batal" <?= $row['status_order']=='Batal'?'selected':'' ?>>Batal</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Status Hantar</label>
                                <select name="status_hantar" class="form-select">
                                    <option value="Belum" <?= $row['status_hantar']=='Belum'?'selected':'' ?>>Belum</option>
                                    <option value="Sudah" <?= $row['status_hantar']=='Sudah'?'selected':'' ?>>Sudah</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Status Bayar</label>
                                <select name="status_bayar" class="form-select" id="status_bayar_<?= $row['id'] ?>" onchange="togglePaymentFields(<?= $row['id'] ?>)">
                                    <option value="Belum" <?= $row['status_bayar']=='Belum'?'selected':'' ?>>Belum</option>
                                    <option value="Sudah" <?= $row['status_bayar']=='Sudah'?'selected':'' ?>>Sudah</option>
                                </select>
                            </div>
                            <div class="mb-3 payment-fields" id="payment_fields_<?= $row['id'] ?>" style="display: <?= $row['status_bayar']=='Sudah'?'block':'none' ?>;">
                                <label class="form-label">Kaedah Pembayaran</label>
                                <select name="payment_method" class="form-select">
                                    <option value="">Pilih kaedah pembayaran</option>
                                    <option value="Transfer/QR" <?= ($row['payment_method'] ?? '')=='Transfer/QR'?'selected':'' ?>>Transfer/QR</option>
                                    <option value="Cash" <?= ($row['payment_method'] ?? '')=='Cash'?'selected':'' ?>>Cash</option>
                                </select>
                            </div>
                            <div class="mb-3 payment-fields" id="payment_date_field_<?= $row['id'] ?>" style="display: <?= $row['status_bayar']=='Sudah'?'block':'none' ?>;">
                                <label class="form-label">Tarikh Bayaran</label>
                                <input type="date" name="payment_date" class="form-control" value="<?= $row['payment_date'] ?? date('Y-m-d') ?>">
                            </div>
                          </div>
                          <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                            <button type="submit" name="update_status" class="btn btn-warning">Kemaskini Status</button>
                          </div>
                          </form>
                        </div>
                      </div>
                    </div>
                    
                    <!-- Modal Delete Tempahan -->
                    <div class="modal fade" id="deleteModal<?= $row['id'] ?>" tabindex="-1">
                      <div class="modal-dialog">
                        <div class="modal-content">
                          <form method="post">
                          <div class="modal-header">
                            <h5 class="modal-title">Padam Tempahan</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                          </div>
                          <div class="modal-body">
                            <input type="hidden" name="order_id" value="<?= $row['id'] ?>">
                            <p>Adakah anda pasti mahu padam tempahan <strong><?= htmlspecialchars($row['customer_name']) ?></strong>?</p>
                            <p class="text-danger"><small>Tindakan ini tidak boleh dibatalkan.</small></p>
                          </div>
                          <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                            <button type="submit" name="delete_order" class="btn btn-danger">Padam</button>
                          </div>
                          </form>
                        </div>
                      </div>
                    </div>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<style>
.btn-whatsapp {
    background-color: #25D366 !important;
    border-color: #25D366 !important;
    color: white !important;
}

.btn-whatsapp:hover {
    background-color: #128C7E !important;
    border-color: #128C7E !important;
    color: white !important;
}

.btn-whatsapp:focus {
    background-color: #25D366 !important;
    border-color: #25D366 !important;
    color: white !important;
    box-shadow: 0 0 0 0.2rem rgba(37, 211, 102, 0.25) !important;
}
</style>

<script>
// Function to toggle payment fields based on payment status
function togglePaymentFields(orderId) {
    const statusSelect = document.getElementById('status_bayar_' + orderId);
    const paymentFields = document.getElementById('payment_fields_' + orderId);
    const paymentDateField = document.getElementById('payment_date_field_' + orderId);
    
    if (statusSelect.value === 'Sudah') {
        paymentFields.style.display = 'block';
        paymentDateField.style.display = 'block';
    } else {
        paymentFields.style.display = 'none';
        paymentDateField.style.display = 'none';
    }
}

// Function to send invoice via WhatsApp
function sendInvoiceWhatsApp(invoiceId, customerPhone) {
    if (!customerPhone) {
        alert('Nombor telefon pelanggan tidak tersedia.');
        return;
    }
    
    // Show loading
    const button = event.target.closest('button');
    const originalContent = button.innerHTML;
    button.innerHTML = '<i class="bi bi-hourglass-split"></i>';
    button.disabled = true;
    
    // Send AJAX request
    fetch('generate_invoice_link.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'invoice_id=' + invoiceId + '&customer_phone=' + encodeURIComponent(customerPhone)
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Open WhatsApp
            window.open(data.whatsapp_url, '_blank');
            
            // Show success message
            alert('Link invoice berjaya dijana! WhatsApp akan dibuka.');
        } else {
            alert('Gagal menjana link invoice: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Ralat sistem. Sila cuba lagi.');
    })
    .finally(() => {
        // Restore button
        button.innerHTML = originalContent;
        button.disabled = false;
    });
}

// Table sorting and search functionality
document.addEventListener('DOMContentLoaded', function() {
    const table = document.querySelector('.table');
    const tbody = table.querySelector('tbody');
    const headers = table.querySelectorAll('th.sortable');
    const searchInput = document.getElementById('searchInput');
    const resultCount = document.getElementById('resultCount');
    
    let allRows = Array.from(tbody.querySelectorAll('tr'));
    let filteredRows = [...allRows];
    
    console.log('Total rows found:', allRows.length);
    
    // Search functionality
    searchInput.addEventListener('input', function() {
        const searchTerm = this.value.toLowerCase();
        console.log('Searching for:', searchTerm);
        
        filteredRows = allRows.filter(row => {
            const cells = row.querySelectorAll('td');
            const rowText = Array.from(cells).map(cell => cell.textContent).join(' ').toLowerCase();
            const matches = rowText.includes(searchTerm);
            console.log('Row text:', rowText, 'Matches:', matches);
            return matches;
        });
        
        console.log('Filtered rows:', filteredRows.length);
        displayRows(filteredRows);
        updateResultCount();
    });
    
    // Sorting functionality
    headers.forEach(header => {
        header.addEventListener('click', function() {
            const sortType = this.getAttribute('data-sort');
            const currentOrder = this.classList.contains('asc') ? 'desc' : 'asc';
            
            // Remove all sort classes
            headers.forEach(h => h.classList.remove('asc', 'desc'));
            
            // Add sort class to current header
            this.classList.add(currentOrder);
            
            // Sort the filtered rows
            sortTable(sortType, currentOrder);
        });
    });
    
    function sortTable(sortType, order) {
        filteredRows.sort((a, b) => {
            let aValue, bValue;
            
            switch(sortType) {
                case 'bil':
                    aValue = parseInt(a.cells[0].textContent);
                    bValue = parseInt(b.cells[0].textContent);
                    break;
                case 'nama':
                    aValue = a.cells[1].textContent.toLowerCase();
                    bValue = b.cells[1].textContent.toLowerCase();
                    break;
                case 'notel':
                    aValue = a.cells[2].textContent.toLowerCase();
                    bValue = b.cells[2].textContent.toLowerCase();
                    break;
                case 'tarikh':
                    aValue = new Date(a.cells[3].textContent);
                    bValue = new Date(b.cells[3].textContent);
                    break;
                case 'pengguna':
                    aValue = a.cells[4].textContent.toLowerCase();
                    bValue = b.cells[4].textContent.toLowerCase();
                    break;
                case 'jualan':
                    aValue = parseFloat(a.cells[5].textContent.replace(/[^\d.-]/g, ''));
                    bValue = parseFloat(b.cells[5].textContent.replace(/[^\d.-]/g, ''));
                    break;
                case 'status':
                    aValue = a.cells[6].textContent.toLowerCase();
                    bValue = b.cells[6].textContent.toLowerCase();
                    break;
                default:
                    return 0;
            }
            
            if (order === 'asc') {
                return aValue > bValue ? 1 : -1;
            } else {
                return aValue < bValue ? 1 : -1;
            }
        });
        
        displayRows(filteredRows);
    }
    
    function displayRows(rows) {
        tbody.innerHTML = '';
        rows.forEach((row, index) => {
            // Clone the row to avoid modifying the original
            const clonedRow = row.cloneNode(true);
            // Update bil number in the cloned row
            clonedRow.cells[0].textContent = index + 1;
            tbody.appendChild(clonedRow);
        });
    }
    
    function updateResultCount() {
        const total = allRows.length;
        const filtered = filteredRows.length;
        resultCount.textContent = `${filtered} / ${total}`;
        
        if (filtered === total) {
            resultCount.className = 'badge bg-secondary';
        } else {
            resultCount.className = 'badge bg-primary';
        }
    }
    
    // Initialize result count
    updateResultCount();
});
</script>

<?php include 'includes/footer.php'; ?> 