<?php
session_start();
include 'includes/db.php';

// Check if user is logged in
if (!isset($_SESSION['user_logged_in'])) {
    header('Location: login.php');
    exit;
}

// Handle link deactivation
if (isset($_POST['deactivate_link'])) {
    $link_id = (int)$_POST['link_id'];
    $deactivate_query = "UPDATE invoice_links SET is_active = 0 WHERE id = ?";
    $stmt = $conn->prepare($deactivate_query);
    $stmt->bind_param('i', $link_id);
    $stmt->execute();
    
    header('Location: manage_invoice_links.php?status=deactivated');
    exit;
}

// Get active invoice links
$links_query = "SELECT il.*, o.customer_name, o.customer_phone, o.order_date, u.realname as created_by_name
                FROM invoice_links il
                LEFT JOIN orders o ON il.invoice_id = o.id
                LEFT JOIN users u ON il.created_by = u.iduser
                WHERE il.is_active = 1
                ORDER BY il.created_at DESC";
$links_result = $conn->query($links_query);

$page_title = 'Urus Link Invoice';
$page_subtitle = 'Senarai Link Invoice Aktif';
$current_page = 'invoice_links';
$base_path = '';

include 'includes/header.php';
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-link-45deg"></i> Urus Link Invoice</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="index.php" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Kembali
        </a>
    </div>
</div>

<?php if (isset($_GET['status']) && $_GET['status'] === 'deactivated'): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <i class="bi bi-check-circle"></i> Link invoice berjaya dinyahaktifkan.
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0"><i class="bi bi-list"></i> Senarai Link Invoice Aktif</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>Bil</th>
                        <th>No. Invoice</th>
                        <th>Nama Pelanggan</th>
                        <th>No. Tel</th>
                        <th>Tarikh Dijana</th>
                        <th>Tarikh Tamat</th>
                        <th>Dijana Oleh</th>
                        <th>Status</th>
                        <th>Tindakan</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $i = 1;
                    while ($link = $links_result->fetch_assoc()): 
                        $is_expired = strtotime($link['expires_at']) < time();
                        $days_left = ceil((strtotime($link['expires_at']) - time()) / (60 * 60 * 24));
                    ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><strong>#<?= $link['invoice_id'] ?></strong></td>
                        <td><?= htmlspecialchars($link['customer_name']) ?></td>
                        <td><?= htmlspecialchars($link['customer_phone']) ?></td>
                        <td><?= date('d/m/Y H:i', strtotime($link['created_at'])) ?></td>
                        <td>
                            <?= date('d/m/Y H:i', strtotime($link['expires_at'])) ?>
                            <?php if ($is_expired): ?>
                                <span class="badge bg-danger">Tamat Tempoh</span>
                            <?php else: ?>
                                <span class="badge bg-<?= $days_left <= 7 ? 'warning' : 'success' ?>">
                                    <?= $days_left ?> hari lagi
                                </span>
                            <?php endif; ?>
                        </td>
                        <td><?= htmlspecialchars($link['created_by_name']) ?></td>
                        <td>
                            <?php if ($is_expired): ?>
                                <span class="badge bg-danger">Tamat Tempoh</span>
                            <?php else: ?>
                                <span class="badge bg-success">Aktif</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <?php if (!$is_expired): ?>
                                <a href="public_invoice.php?id=<?= $link['invoice_id'] ?>&token=<?= $link['token'] ?>" 
                                   class="btn btn-sm btn-primary" target="_blank" title="Lihat Invoice">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <?php endif; ?>
                                <form method="post" style="display: inline;" onsubmit="return confirm('Adakah anda pasti mahu menyahaktifkan link ini?')">
                                    <input type="hidden" name="link_id" value="<?= $link['id'] ?>">
                                    <button type="submit" name="deactivate_link" class="btn btn-sm btn-danger" title="Nyahaktifkan Link">
                                        <i class="bi bi-x-circle"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                    
                    <?php if ($links_result->num_rows === 0): ?>
                    <tr>
                        <td colspan="9" class="text-center text-muted">
                            <i class="bi bi-inbox"></i> Tiada link invoice aktif
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="mt-4">
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0"><i class="bi bi-info-circle"></i> Maklumat Link Invoice</h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h6>Ciri-ciri Link Invoice:</h6>
                    <ul>
                        <li>Link sah selama 30 hari dari tarikh dijana</li>
                        <li>Link boleh diakses tanpa login</li>
                        <li>Link akan tamat tempoh secara automatik</li>
                        <li>Link boleh dinyahaktifkan secara manual</li>
                    </ul>
                </div>
                <div class="col-md-6">
                    <h6>Status Link:</h6>
                    <ul>
                        <li><span class="badge bg-success">Aktif</span> - Link masih boleh digunakan</li>
                        <li><span class="badge bg-warning">Tamat Tempoh</span> - Link akan tamat dalam 7 hari atau kurang</li>
                        <li><span class="badge bg-danger">Tamat Tempoh</span> - Link tidak boleh digunakan lagi</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?> 