<?php
// Set page variables for header
$page_title = 'Jualan Saya';
$page_subtitle = 'Analisis Jualan Peribadi';
$current_page = 'my_sales';
$base_path = '';

include 'includes/header.php';

// Get filter parameters
$year = isset($_GET['year']) ? (int)$_GET['year'] : date('Y');
$month = isset($_GET['month']) ? $_GET['month'] : 'all';

// Build WHERE clause for user's orders
$where_clause = "WHERE o.user_id = " . $_SESSION['user_id'];

if ($month !== 'all') {
    $where_clause .= " AND YEAR(o.order_date) = $year AND MONTH(o.order_date) = $month";
} else {
    $where_clause .= " AND YEAR(o.order_date) = $year";
}

// Get summary statistics for current user
$summary_query = "SELECT 
    COUNT(*) as total_orders,
    SUM(o.total_sale) as total_sales,
    SUM(o.total_cost_price) as total_cost,
    SUM(o.total_sale - o.total_cost_price) as total_profit,
    AVG(o.total_sale) as avg_sale,
    AVG(o.total_sale - o.total_cost_price) as avg_profit
FROM orders o 
$where_clause";

$summary_result = $conn->query($summary_query);
$summary = $summary_result->fetch_assoc();

// Get payment statistics
$payment_query = "SELECT 
    SUM(CASE WHEN o.status_bayar = 'Sudah' THEN 1 ELSE 0 END) as paid_count,
    SUM(CASE WHEN o.status_bayar = 'Sudah' THEN o.total_sale ELSE 0 END) as paid_amount,
    SUM(CASE WHEN o.status_bayar = 'Belum' THEN 1 ELSE 0 END) as unpaid_count,
    SUM(CASE WHEN o.status_bayar = 'Belum' THEN o.total_sale ELSE 0 END) as unpaid_amount
FROM orders o 
$where_clause";

$payment_result = $conn->query($payment_query);
$payment = $payment_result->fetch_assoc();

// Get status statistics
$status_query = "SELECT 
    SUM(CASE WHEN o.status_order = 'Baru' THEN 1 ELSE 0 END) as new_orders,
    SUM(CASE WHEN o.status_order = 'Dalam Proses' THEN 1 ELSE 0 END) as in_progress_orders,
    SUM(CASE WHEN o.status_order = 'Siap' AND o.status_hantar = 'Belum' THEN 1 ELSE 0 END) as ready_not_shipped,
    SUM(CASE WHEN o.status_order = 'Siap' AND o.status_hantar = 'Sudah' AND o.status_bayar = 'Belum' THEN 1 ELSE 0 END) as ready_shipped_unpaid,
    SUM(CASE WHEN o.status_order = 'Siap' AND o.status_hantar = 'Sudah' AND o.status_bayar = 'Belum' THEN o.total_sale ELSE 0 END) as ready_shipped_unpaid_amount
FROM orders o 
$where_clause";

$status_result = $conn->query($status_query);
$status = $status_result->fetch_assoc();

// Get detailed orders with profit calculation
$detailed_query = "SELECT 
    o.*,
    c.name as customer_name,
    (o.total_sale - o.total_cost_price) as profit,
    CASE 
        WHEN o.total_sale > 0 THEN ROUND(((o.total_sale - o.total_cost_price) / o.total_sale) * 100, 1)
        ELSE 0 
    END as margin_percent
FROM orders o 
LEFT JOIN customers c ON o.customer_id = c.id
$where_clause
ORDER BY o.order_date DESC";

$detailed_result = $conn->query($detailed_query);

// Get unique years for filter
$years_query = "SELECT DISTINCT YEAR(order_date) as year FROM orders WHERE user_id = " . $_SESSION['user_id'] . " ORDER BY year DESC";
$years_result = $conn->query($years_query);
$years = [];
while ($row = $years_result->fetch_assoc()) {
    $years[] = $row['year'];
}
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-person-check"></i> Jualan Saya</h1>
    <div class="d-flex gap-2 align-items-center">
        <div class="d-flex gap-2">
            <select class="form-select form-select-sm" style="width: auto; min-width: 80px;" onchange="updateFilter()" id="yearFilter">
                <?php foreach ($years as $y): ?>
                    <option value="<?= $y ?>" <?= $y == $year ? 'selected' : '' ?>><?= $y ?></option>
                <?php endforeach; ?>
            </select>
            <select class="form-select form-select-sm" style="width: auto; min-width: 120px;" onchange="updateFilter()" id="monthFilter">
                <option value="all" <?= $month == 'all' ? 'selected' : '' ?>>Semua Bulan</option>
                <option value="1" <?= $month == '1' ? 'selected' : '' ?>>Januari</option>
                <option value="2" <?= $month == '2' ? 'selected' : '' ?>>Februari</option>
                <option value="3" <?= $month == '3' ? 'selected' : '' ?>>Mac</option>
                <option value="4" <?= $month == '4' ? 'selected' : '' ?>>April</option>
                <option value="5" <?= $month == '5' ? 'selected' : '' ?>>Mei</option>
                <option value="6" <?= $month == '6' ? 'selected' : '' ?>>Jun</option>
                <option value="7" <?= $month == '7' ? 'selected' : '' ?>>Julai</option>
                <option value="8" <?= $month == '8' ? 'selected' : '' ?>>Ogos</option>
                <option value="9" <?= $month == '9' ? 'selected' : '' ?>>September</option>
                <option value="10" <?= $month == '10' ? 'selected' : '' ?>>Oktober</option>
                <option value="11" <?= $month == '11' ? 'selected' : '' ?>>November</option>
                <option value="12" <?= $month == '12' ? 'selected' : '' ?>>Disember</option>
            </select>
        </div>
    </div>
</div>

<!-- Summary Cards -->
<div class="row mb-4">
    <div class="col-md-4">
        <div class="card bg-primary text-white">
            <div class="card-body text-center">
                <h4 class="card-title">Jumlah Jualan</h4>
                <h2 class="mb-0">RM <?= number_format($summary['total_sales'] ?? 0, 2) ?></h2>
                <small><?= $summary['total_orders'] ?? 0 ?> tempahan</small>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-warning text-white">
            <div class="card-body text-center">
                <h4 class="card-title">Jumlah Kos</h4>
                <h2 class="mb-0">RM <?= number_format($summary['total_cost'] ?? 0, 2) ?></h2>
                <small>Purata RM <?= number_format($summary['avg_sale'] ?? 0, 2) ?> seorder</small>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-success text-white">
            <div class="card-body text-center">
                <h4 class="card-title">Jumlah Untung</h4>
                <h2 class="mb-0">RM <?= number_format($summary['total_profit'] ?? 0, 2) ?></h2>
                <small>Purata RM <?= number_format($summary['avg_profit'] ?? 0, 2) ?> seorder</small>
            </div>
        </div>
    </div>
</div>

<!-- Payment and Status Analysis -->
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-credit-card"></i> Status Pembayaran</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-6">
                        <div class="text-center">
                            <h3 class="text-success"><?= $payment['paid_count'] ?? 0 ?></h3>
                            <p class="mb-1">Sudah Bayar</p>
                            <small class="text-muted">RM <?= number_format($payment['paid_amount'] ?? 0, 2) ?></small>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="text-center">
                            <h3 class="text-danger"><?= $payment['unpaid_count'] ?? 0 ?></h3>
                            <p class="mb-1">Belum Bayar</p>
                            <small class="text-muted">RM <?= number_format($payment['unpaid_amount'] ?? 0, 2) ?></small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-list-check"></i> Status Order</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-4">
                        <div class="text-center">
                            <h3 class="text-secondary"><?= $status['new_orders'] ?? 0 ?></h3>
                            <p class="mb-1">Order Baru</p>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="text-center">
                            <h3 class="text-info"><?= $status['ready_not_shipped'] ?? 0 ?></h3>
                            <p class="mb-1">Order Siap (Belum Hantar)</p>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="text-center">
                            <h3 class="text-warning"><?= $status['ready_shipped_unpaid'] ?? 0 ?></h3>
                            <p class="mb-1">Belum Bayar (Siap & Hantar)</p>
                            <small class="text-muted">RM <?= number_format($status['ready_shipped_unpaid_amount'] ?? 0, 2) ?></small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Detailed Analysis Table -->
<div class="card">
    <div class="card-header">
        <h5 class="mb-0"><i class="bi bi-table"></i> Senarai Terperinci Jualan Saya</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>Bil</th>
                        <th>Nama Pelanggan</th>
                        <th>Tarikh Order</th>
                        <th class="text-end">Jualan (RM)</th>
                        <th class="text-end">Kos (RM)</th>
                        <th class="text-end">Untung (RM)</th>
                        <th>Status Order</th>
                        <th>Penghantaran</th>
                        <th>Pembayaran</th>
                        <th class="text-end">Margin (%)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; while ($row = $detailed_result->fetch_assoc()): ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= htmlspecialchars($row['customer_name'] ?? $row['customer_name']) ?></td>
                        <td><?= date('d/m/Y', strtotime($row['order_date'])) ?></td>
                        <td class="text-end"><?= number_format($row['total_sale'], 2) ?></td>
                        <td class="text-end"><?= number_format($row['total_cost_price'], 2) ?></td>
                        <td class="text-end">
                            <span class="badge bg-<?= $row['profit'] >= 0 ? 'success' : 'danger' ?>">
                                <?= number_format($row['profit'], 2) ?>
                            </span>
                        </td>
                        <td>
                            <span class="badge bg-<?= $row['status_order'] == 'Siap' ? 'success' : ($row['status_order'] == 'Batal' ? 'danger' : ($row['status_order'] == 'Dalam Proses' ? 'warning' : 'secondary')) ?>">
                                <?= $row['status_order'] ?>
                            </span>
                        </td>
                        <td>
                            <span class="badge bg-<?= $row['status_hantar'] == 'Sudah' ? 'info' : 'secondary' ?>">
                                <?= $row['status_hantar'] ?>
                            </span>
                        </td>
                        <td>
                            <span class="badge bg-<?= $row['status_bayar'] == 'Sudah' ? 'primary' : 'secondary' ?>">
                                <?= $row['status_bayar'] ?>
                            </span>
                        </td>
                        <td class="text-end">
                            <span class="badge bg-<?= $row['margin_percent'] >= 0 ? 'success' : 'danger' ?>">
                                <?= $row['margin_percent'] ?>%
                            </span>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
                <tfoot class="table-dark">
                    <tr>
                        <th colspan="3">JUMLAH KESELURUHAN</th>
                        <th class="text-end">RM <?= number_format($summary['total_sales'] ?? 0, 2) ?></th>
                        <th class="text-end">RM <?= number_format($summary['total_cost'] ?? 0, 2) ?></th>
                        <th class="text-end">RM <?= number_format($summary['total_profit'] ?? 0, 2) ?></th>
                        <th colspan="3"></th>
                        <th class="text-end">
                            <?php 
                            $total_margin = $summary['total_sales'] > 0 ? 
                                (($summary['total_profit'] / $summary['total_sales']) * 100) : 0;
                            ?>
                            <span class="badge bg-<?= $total_margin >= 0 ? 'success' : 'danger' ?>">
                                <?= round($total_margin, 1) ?>%
                            </span>
                        </th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>

<script>
function updateFilter() {
    const year = document.getElementById('yearFilter').value;
    const month = document.getElementById('monthFilter').value;
    window.location.href = `my_sales.php?year=${year}&month=${month}`;
}
</script>

<?php include 'includes/footer.php'; ?> 