<?php
// Error reporting untuk debug
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// Check if admin is logged in
if (!isset($_SESSION['user_logged_in']) || $_SESSION['user_peranan'] !== 'Admin') {
    header('Location: ../login.php');
    exit;
}

// Include database connection
include '../includes/db.php';

// Get shop info for logo
$shop = $conn->query("SELECT * FROM shop_info WHERE id=1")->fetch_assoc();

// Dapatkan tahun unik
$years = [];
$res = $conn->query("SELECT DISTINCT YEAR(order_date) as y FROM orders ORDER BY y DESC");
while($r = $res->fetch_assoc()) $years[] = $r['y'];
$year = isset($_GET['year']) ? (int)$_GET['year'] : (count($years)?$years[0]:date('Y'));
$month = isset($_GET['month']) ? (int)$_GET['month'] : 0;
$where = "WHERE YEAR(order_date) = $year";
if ($month > 0) $where .= " AND MONTH(order_date) = $month";

// Dapatkan data tempahan terperinci
$sql = "SELECT id, customer_name, order_date, total_sale, total_cost_price, (total_sale - total_cost_price) as untung, status_order FROM orders $where ORDER BY order_date DESC";
$res = $conn->query($sql);
$orders = [];
while($row = $res->fetch_assoc()) $orders[] = $row;

// Kira jumlah keseluruhan
$total_jualan = array_sum(array_column($orders, 'total_sale'));
$total_kos = array_sum(array_column($orders, 'total_cost_price'));
$total_untung = $total_jualan - $total_kos;

// Analisis tambahan untuk statistik pembayaran dan status
$sql_stats = "SELECT 
    COUNT(*) as total_orders,
    SUM(CASE WHEN status_bayar = 'Sudah' THEN 1 ELSE 0 END) as sudah_bayar_count,
    SUM(CASE WHEN status_bayar = 'Belum' THEN 1 ELSE 0 END) as belum_bayar_count,
    SUM(CASE WHEN status_bayar = 'Sudah' THEN total_sale ELSE 0 END) as sudah_bayar_amount,
    SUM(CASE WHEN status_bayar = 'Belum' THEN total_sale ELSE 0 END) as belum_bayar_amount,
    SUM(CASE WHEN status_order = 'Baru' THEN 1 ELSE 0 END) as order_baru_count,
    SUM(CASE WHEN status_order = 'Siap' AND status_hantar = 'Belum' THEN 1 ELSE 0 END) as order_siap_belum_hantar_count,
    SUM(CASE WHEN status_order = 'Siap' AND status_hantar = 'Sudah' AND status_bayar = 'Belum' THEN 1 ELSE 0 END) as order_siap_sudah_hantar_belum_bayar_count,
    SUM(CASE WHEN status_order = 'Siap' AND status_hantar = 'Sudah' AND status_bayar = 'Belum' THEN total_sale ELSE 0 END) as order_siap_sudah_hantar_belum_bayar_amount
FROM orders $where";

$stats = $conn->query($sql_stats)->fetch_assoc();

// Dapatkan data tempahan terperinci dengan semua maklumat status
$sql = "SELECT id, customer_name, order_date, total_sale, total_cost_price, (total_sale - total_cost_price) as untung, status_order, status_hantar, status_bayar FROM orders $where ORDER BY order_date DESC";
$res = $conn->query($sql);
$orders = [];
while($row = $res->fetch_assoc()) $orders[] = $row;
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Analisis Jualan & Untung - Sistem Tempahan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body { background: #f8f9fa; }
        .sidebar { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; min-height: 100vh; }
        .main-content { min-height: 100vh; padding: 20px; }
        .card { border: none; box-shadow: 0 2px 8px rgba(0,0,0,0.1); border-radius: 12px; }
        .card-header { background: linear-gradient(45deg, #007bff, #0056b3); color: white; border-radius: 12px 12px 0 0 !important; border: none; }
        .nav-link { border-radius: 8px; margin-bottom: 4px; transition: all 0.3s ease; color: rgba(255,255,255,0.8); }
        .nav-link:hover { background: rgba(255,255,255,0.1); transform: translateX(5px); color: white; }
        .nav-link.active { background: rgba(255,255,255,0.2); color: white !important; }
        .summary-card { border-radius: 12px; border: none; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
        .table th { 
            background: #343a40 !important; 
            color: white !important;
            border-top: none; 
            font-weight: 600; 
        }
        
        .table-dark th {
            background: #212529 !important;
            color: white !important;
        }
        
        .table-light th {
            background: #6c757d !important;
            color: white !important;
        }
        
        /* Enhanced responsive sidebar */
        @media (max-width: 767.98px) {
            .sidebar {
                position: fixed;
                top: 0;
                left: -100%;
                height: 100vh;
                z-index: 1050;
                transition: left 0.3s ease;
                width: 280px;
                overflow-y: auto;
            }
            
            .sidebar.show {
                left: 0;
            }
            
            .main-content {
                margin-left: 0 !important;
                width: 100% !important;
            }
            
            /* Enhanced overlay when sidebar is open */
            .sidebar-overlay {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: rgba(0,0,0,0.5);
                z-index: 1040;
                display: none;
                opacity: 0;
                transition: opacity 0.3s ease;
            }
            
            .sidebar-overlay.show {
                display: block;
                opacity: 1;
            }
        }
        
        /* Enhanced mobile menu button */
        .menu-toggle {
            display: none;
            position: fixed;
            top: 15px;
            left: 15px;
            z-index: 1060;
            background: #007bff;
            border: none;
            color: white;
            padding: 10px 14px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.2);
            transition: all 0.3s ease;
            font-size: 18px;
        }
        
        .menu-toggle:hover {
            background: #0056b3;
            transform: scale(1.05);
            box-shadow: 0 6px 16px rgba(0,0,0,0.3);
        }
        
        @media (max-width: 767.98px) {
            .menu-toggle {
                display: block;
            }
        }
        
        /* Additional responsive improvements */
        @media (max-width: 575.98px) {
            .sidebar {
                width: 100%;
                left: -100%;
            }
            
            .menu-toggle {
                top: 10px;
                left: 10px;
                padding: 8px 12px;
            }
        }
        
        /* Prevent body scroll when sidebar is open on mobile */
        body.sidebar-open {
            overflow: hidden;
        }
    </style>
</head>
<body>
<!-- Mobile menu button -->
<button class="menu-toggle" onclick="toggleSidebar()" aria-label="Toggle Sidebar">
    <i class="bi bi-list"></i>
</button>

<!-- Overlay for mobile -->
<div class="sidebar-overlay" onclick="toggleSidebar()"></div>

<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-md-3 col-lg-2 sidebar p-0">
            <div class="p-4">
                <div class="text-center mb-4">
                    <?php if ($shop && $shop['logo_image']): ?>
                        <img src="../uploads/<?= htmlspecialchars($shop['logo_image']) ?>" 
                             alt="Logo Kedai" 
                             class="img-fluid mb-3" 
                             style="max-height: 80px; max-width: 100%; border-radius: 8px;">
                    <?php endif; ?>
                    <h4 class="mb-0"><i class="bi bi-shop"></i> Sistem Tempahan</h4>
                    <small class="text-white-50"><?= htmlspecialchars($shop['shop_name'] ?? 'ALH DESIGN ENTERPRISE') ?></small>
                </div>
                <nav class="nav flex-column">
                    <a class="nav-link" href="../tempahan.php">
                        <i class="bi bi-plus-circle"></i> Tambah Tempahan
                    </a>
                    <a class="nav-link" href="../index.php">
                        <i class="bi bi-list-ul"></i> Senarai Tempahan
                    </a>
                    <a class="nav-link active" href="analisis.php">
                        <i class="bi bi-graph-up"></i> Analisis
                    </a>
                    <hr class="my-3 border-white">
                    <a class="nav-link" href="index.php">
                        <i class="bi bi-gear"></i> Panel Admin
                    </a>
                    <a class="nav-link" href="users.php">
                        <i class="bi bi-people"></i> Pengurusan Pengguna
                    </a>
                </nav>
                <hr class="my-3 border-white">
                <div class="text-center">
                    <small class="text-white-50">Log masuk sebagai:</small><br>
                    <strong class="text-white"><?= htmlspecialchars($_SESSION['realname']) ?></strong><br>
                    <span class="badge bg-danger"><?= $_SESSION['user_peranan'] ?></span>
                </div>
                <hr class="my-3 border-white">
                <div class="text-center">
                    <a href="logout.php" class="btn btn-outline-light btn-sm">
                        <i class="bi bi-box-arrow-right"></i> Logout
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Main Content -->
        <div class="col-md-9 col-lg-10 main-content p-4">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2>Analisis Jualan, Kos & Untung</h2>
                <a href="../index.php" class="btn btn-secondary btn-modern">
                    <i class="bi bi-arrow-left"></i> Kembali ke Tempahan
                </a>
            </div>
            
            <form class="row g-2 mb-3" method="get">
                <div class="col-auto">
                    <select name="year" class="form-select" onchange="this.form.submit()">
                        <?php foreach($years as $y): ?><option value="<?= $y ?>" <?= $y==$year?'selected':'' ?>><?= $y ?></option><?php endforeach; ?>
                    </select>
                </div>
                <div class="col-auto">
                    <select name="month" class="form-select" onchange="this.form.submit()">
                        <option value="0">Semua Bulan</option>
                        <?php for($m=1;$m<=12;$m++): ?><option value="<?= $m ?>" <?= $m==$month?'selected':'' ?>><?= date('F', mktime(0,0,0,$m,1)) ?></option><?php endfor; ?>
                    </select>
                </div>
            </form>
            
            <!-- Ringkasan -->
            <div class="row mb-4">
                <div class="col-md-4">
                    <div class="card summary-card bg-primary text-white">
                        <div class="card-body text-center">
                            <h4 class="card-title">Jumlah Jualan</h4>
                            <h3 class="mb-0">RM <?= number_format($total_jualan, 2) ?></h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card summary-card bg-warning text-white">
                        <div class="card-body text-center">
                            <h4 class="card-title">Jumlah Kos</h4>
                            <h3 class="mb-0">RM <?= number_format($total_kos, 2) ?></h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card summary-card bg-success text-white">
                        <div class="card-body text-center">
                            <h4 class="card-title">Jumlah Untung</h4>
                            <h3 class="mb-0">RM <?= number_format($total_untung, 2) ?></h3>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Analisis Tambahan - Statistik Pembayaran & Status -->
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-credit-card"></i> Analisis Pembayaran</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <div class="text-center p-3 bg-success text-white rounded">
                                        <h4 class="mb-1"><?= $stats['sudah_bayar_count'] ?></h4>
                                        <small>Sudah Bayar</small>
                                        <div class="mt-2">
                                            <strong>RM <?= number_format($stats['sudah_bayar_amount'], 2) ?></strong>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="text-center p-3 bg-danger text-white rounded">
                                        <h4 class="mb-1"><?= $stats['belum_bayar_count'] ?></h4>
                                        <small>Belum Bayar</small>
                                        <div class="mt-2">
                                            <strong>RM <?= number_format($stats['belum_bayar_amount'], 2) ?></strong>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-list-check"></i> Analisis Status Order</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <div class="text-center p-3 bg-secondary text-white rounded">
                                        <h4 class="mb-1"><?= $stats['order_baru_count'] ?></h4>
                                        <small>Order Baru</small>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <div class="text-center p-3 bg-info text-white rounded">
                                        <h4 class="mb-1"><?= $stats['order_siap_belum_hantar_count'] ?></h4>
                                        <small>Order Siap (Belum Hantar)</small>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <div class="text-center p-3 bg-warning text-white rounded">
                                        <h4 class="mb-1"><?= $stats['order_siap_sudah_hantar_belum_bayar_count'] ?></h4>
                                        <small>Belum Bayar (Siap & Hantar)</small>
                                        <div class="mt-2">
                                            <strong>RM <?= number_format($stats['order_siap_sudah_hantar_belum_bayar_amount'], 2) ?></strong>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-table"></i> Analisis Terperinci Setiap Tempahan</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="table-dark">
                                <tr>
                                    <th>Bil</th>
                                    <th>Nama Pelanggan</th>
                                    <th>Tarikh Order</th>
                                    <th>Jualan (RM)</th>
                                    <th>Kos (RM)</th>
                                    <th>Untung (RM)</th>
                                    <th>Status Order</th>
                                    <th>Penghantaran</th>
                                    <th>Pembayaran</th>
                                    <th>Margin (%)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1; foreach($orders as $order): ?>
                                <tr>
                                    <td><?= $i++ ?></td>
                                    <td><?= htmlspecialchars($order['customer_name']) ?></td>
                                    <td><?= date('d/m/Y', strtotime($order['order_date'])) ?></td>
                                    <td class="text-end"><?= number_format($order['total_sale'], 2) ?></td>
                                    <td class="text-end"><?= number_format($order['total_cost_price'], 2) ?></td>
                                    <td class="text-end">
                                        <span class="badge bg-<?= $order['untung'] >= 0 ? 'success' : 'danger' ?>">
                                            <?= number_format($order['untung'], 2) ?>
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?= $order['status_order']==='Siap'?'success':($order['status_order']==='Batal'?'danger':'secondary') ?>">
                                            <?= $order['status_order'] ?>
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?= $order['status_hantar']==='Sudah'?'info':'secondary' ?>">
                                            <?= $order['status_hantar'] ?>
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?= $order['status_bayar']==='Sudah'?'success':'warning' ?>">
                                            <?= $order['status_bayar'] ?>
                                        </span>
                                    </td>
                                    <td class="text-end">
                                        <?php 
                                        $margin = $order['total_sale'] > 0 ? ($order['untung'] / $order['total_sale']) * 100 : 0;
                                        $margin_color = $margin >= 20 ? 'success' : ($margin >= 10 ? 'warning' : 'danger');
                                        ?>
                                        <span class="badge bg-<?= $margin_color ?>">
                                            <?= number_format($margin, 1) ?>%
                                        </span>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot class="table-dark">
                                <tr>
                                    <th colspan="3">JUMLAH KESELURUHAN</th>
                                    <th class="text-end"><?= number_format($total_jualan, 2) ?></th>
                                    <th class="text-end"><?= number_format($total_kos, 2) ?></th>
                                    <th class="text-end">
                                        <span class="badge bg-<?= $total_untung >= 0 ? 'success' : 'danger' ?>">
                                            <?= number_format($total_untung, 2) ?>
                                        </span>
                                    </th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th class="text-end">
                                        <?php 
                                        $total_margin = $total_jualan > 0 ? ($total_untung / $total_jualan) * 100 : 0;
                                        $total_margin_color = $total_margin >= 20 ? 'success' : ($total_margin >= 10 ? 'warning' : 'danger');
                                        ?>
                                        <span class="badge bg-<?= $total_margin_color ?>">
                                            <?= number_format($total_margin, 1) ?>%
                                        </span>
                                    </th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
function toggleSidebar() {
    const sidebar = document.querySelector('.sidebar');
    const overlay = document.querySelector('.sidebar-overlay');
    const body = document.body;
    
    sidebar.classList.toggle('show');
    overlay.classList.toggle('show');
    
    // Prevent body scroll when sidebar is open
    if (sidebar.classList.contains('show')) {
        body.classList.add('sidebar-open');
    } else {
        body.classList.remove('sidebar-open');
    }
}

// Close sidebar when clicking on a link (mobile)
document.querySelectorAll('.sidebar .nav-link').forEach(link => {
    link.addEventListener('click', () => {
        if (window.innerWidth <= 767.98) {
            toggleSidebar();
        }
    });
});

// Enhanced window resize handler
window.addEventListener('resize', () => {
    const sidebar = document.querySelector('.sidebar');
    const overlay = document.querySelector('.sidebar-overlay');
    const body = document.body;
    
    if (window.innerWidth > 767.98) {
        sidebar.classList.remove('show');
        overlay.classList.remove('show');
        body.classList.remove('sidebar-open');
    }
});

// Close sidebar on escape key
document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape') {
        const sidebar = document.querySelector('.sidebar');
        if (sidebar.classList.contains('show')) {
            toggleSidebar();
        }
    }
});

// Auto-hide sidebar when clicking outside (for larger screens)
document.addEventListener('click', (e) => {
    const sidebar = document.querySelector('.sidebar');
    const toggle = document.querySelector('.menu-toggle');
    
    if (window.innerWidth <= 767.98 && 
        sidebar.classList.contains('show') && 
        !sidebar.contains(e.target) && 
        !toggle.contains(e.target)) {
        toggleSidebar();
    }
});

// Initialize sidebar state on page load
document.addEventListener('DOMContentLoaded', () => {
    // Ensure sidebar is hidden on mobile on page load
    if (window.innerWidth <= 767.98) {
        const sidebar = document.querySelector('.sidebar');
        const overlay = document.querySelector('.sidebar-overlay');
        const body = document.body;
        
        sidebar.classList.remove('show');
        overlay.classList.remove('show');
        body.classList.remove('sidebar-open');
    }
});
</script>
</body>
</html> 