<?php
// Error reporting untuk debug
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// Check if admin is logged in
if (!isset($_SESSION['user_logged_in']) || $_SESSION['user_peranan'] !== 'Admin') {
    header('Location: ../login.php');
    exit;
}

include '../includes/db.php';

// Get shop info
$shop = $conn->query("SELECT * FROM shop_info WHERE id=1")->fetch_assoc();
if (!$shop) {
    // Create default shop info if not exists
    $conn->query("INSERT INTO shop_info (shop_name, shop_address, shop_phone, manager_name) VALUES ('ALH DESIGN ENTERPRISE', 'Alamat Kedai', '0123456789', 'Pengurus')");
    $shop = $conn->query("SELECT * FROM shop_info WHERE id=1")->fetch_assoc();
}

// Get prices
$prices = [];
$res = $conn->query("SELECT * FROM prices");
while ($row = $res->fetch_assoc()) {
    $prices[$row['item_type']] = $row;
}

// Process form submissions
if (isset($_POST['update_shop'])) {
    $shop_name = $_POST['shop_name'];
    $shop_address = $_POST['shop_address'];
    $shop_phone = $_POST['shop_phone'];
    $manager_name = $_POST['manager_name'];
    $bank_name = $_POST['bank_name'];
    $bank_account = $_POST['bank_account'];
    $bank_owner = $_POST['bank_owner'];
    
    $stmt = $conn->prepare("UPDATE shop_info SET shop_name=?, shop_address=?, shop_phone=?, manager_name=?, bank_name=?, bank_account=?, bank_owner=? WHERE id=1");
    $stmt->bind_param('sssssss', $shop_name, $shop_address, $shop_phone, $manager_name, $bank_name, $bank_account, $bank_owner);
    $stmt->execute();
    $stmt->close();
    
    // Handle logo upload
    if (isset($_FILES['logo_image']) && $_FILES['logo_image']['error'] == UPLOAD_ERR_OK) {
        $allowed = ['jpg', 'jpeg', 'png'];
        $filename = $_FILES['logo_image']['name'];
        $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        
        if (in_array($ext, $allowed) && $_FILES['logo_image']['size'] <= 5000000) {
            $newname = 'logo_' . time() . '.' . $ext;
            if (move_uploaded_file($_FILES['logo_image']['tmp_name'], '../uploads/' . $newname)) {
                $conn->query("UPDATE shop_info SET logo_image='$newname' WHERE id=1");
            }
        }
    }
    
    // Handle stamp upload
    if (isset($_FILES['stamp_image']) && $_FILES['stamp_image']['error'] == UPLOAD_ERR_OK) {
        $allowed = ['jpg', 'jpeg', 'png'];
        $filename = $_FILES['stamp_image']['name'];
        $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        
        if (in_array($ext, $allowed) && $_FILES['stamp_image']['size'] <= 5000000) {
            $newname = 'stamp_' . time() . '.' . $ext;
            if (move_uploaded_file($_FILES['stamp_image']['tmp_name'], '../uploads/' . $newname)) {
                $conn->query("UPDATE shop_info SET stamp_image='$newname' WHERE id=1");
            }
        }
    }
    
    // Handle signature upload
    if (isset($_FILES['sign_image']) && $_FILES['sign_image']['error'] == UPLOAD_ERR_OK) {
        $allowed = ['jpg', 'jpeg', 'png'];
        $filename = $_FILES['sign_image']['name'];
        $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        
        if (in_array($ext, $allowed) && $_FILES['sign_image']['size'] <= 5000000) {
            $newname = 'sign_' . time() . '.' . $ext;
            if (move_uploaded_file($_FILES['sign_image']['tmp_name'], '../uploads/' . $newname)) {
                $conn->query("UPDATE shop_info SET sign_image='$newname' WHERE id=1");
            }
        }
    }
    
    header('Location: index.php?success=1');
    exit;
}

if (isset($_POST['update_prices'])) {
    foreach ($_POST['prices'] as $type => $data) {
        $sale_price = (float)$data['sale_price'];
        $purchase_price = (float)$data['purchase_price'];
        $stmt = $conn->prepare("UPDATE prices SET sale_price=?, purchase_price=? WHERE item_type=?");
        $stmt->bind_param('dds', $sale_price, $purchase_price, $type);
        $stmt->execute();
        $stmt->close();
    }
    header('Location: index.php?prices=1');
    exit;
}

// Delete images
if (isset($_POST['delete_logo'])) {
    if ($shop['logo_image'] && file_exists('../uploads/' . $shop['logo_image'])) {
        unlink('../uploads/' . $shop['logo_image']);
    }
    $conn->query("UPDATE shop_info SET logo_image=NULL WHERE id=1");
    header('Location: index.php?delete=1');
    exit;
}

if (isset($_POST['delete_stamp'])) {
    if ($shop['stamp_image'] && file_exists('../uploads/' . $shop['stamp_image'])) {
        unlink('../uploads/' . $shop['stamp_image']);
    }
    $conn->query("UPDATE shop_info SET stamp_image=NULL WHERE id=1");
    header('Location: index.php?delete=1');
    exit;
}

if (isset($_POST['delete_sign'])) {
    if ($shop['sign_image'] && file_exists('../uploads/' . $shop['sign_image'])) {
        unlink('../uploads/' . $shop['sign_image']);
    }
    $conn->query("UPDATE shop_info SET sign_image=NULL WHERE id=1");
    header('Location: index.php?delete=1');
    exit;
}

// Refresh shop info after updates
$shop = $conn->query("SELECT * FROM shop_info WHERE id=1")->fetch_assoc();
$prices = [];
$res = $conn->query("SELECT * FROM prices");
while ($row = $res->fetch_assoc()) {
    $prices[$row['item_type']] = $row;
}
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panel Admin - Sistem Tempahan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body { background: #f8f9fa; }
        .sidebar { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; min-height: 100vh; }
        .main-content { min-height: 100vh; padding: 20px; }
        .card { border: none; box-shadow: 0 2px 8px rgba(0,0,0,0.1); border-radius: 12px; }
        .card-header { background: linear-gradient(45deg, #007bff, #0056b3); color: white; border-radius: 12px 12px 0 0 !important; border: none; }
        .nav-link { border-radius: 8px; margin-bottom: 4px; transition: all 0.3s ease; color: rgba(255,255,255,0.8); }
        .nav-link:hover { background: rgba(255,255,255,0.1); transform: translateX(5px); color: white; }
        .nav-link.active { background: rgba(255,255,255,0.2); color: white !important; }
        .form-control, .form-select { border-radius: 8px; border: 1px solid #dee2e6; }
        .form-control:focus, .form-select:focus { border-color: #007bff; box-shadow: 0 0 0 0.2rem rgba(0,123,255,0.25); }
        .btn-modern { border-radius: 8px; padding: 8px 16px; font-weight: 500; transition: all 0.3s ease; }
        .btn-modern:hover { transform: translateY(-2px); box-shadow: 0 4px 12px rgba(0,0,0,0.15); }
        
        /* Table styling */
        .table th { 
            background: #343a40 !important; 
            color: white !important;
            border-top: none; 
            font-weight: 600; 
        }
        
        .table-dark th {
            background: #212529 !important;
            color: white !important;
        }
        
        .table-light th {
            background: #6c757d !important;
            color: white !important;
        }
        
        /* Enhanced responsive sidebar */
        @media (max-width: 767.98px) {
            .sidebar {
                position: fixed;
                top: 0;
                left: -100%;
                height: 100vh;
                z-index: 1050;
                transition: left 0.3s ease;
                width: 280px;
                overflow-y: auto;
            }
            
            .sidebar.show {
                left: 0;
            }
            
            .main-content {
                margin-left: 0 !important;
                width: 100% !important;
            }
            
            /* Enhanced overlay when sidebar is open */
            .sidebar-overlay {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: rgba(0,0,0,0.5);
                z-index: 1040;
                display: none;
                opacity: 0;
                transition: opacity 0.3s ease;
            }
            
            .sidebar-overlay.show {
                display: block;
                opacity: 1;
            }
        }
        
        /* Enhanced mobile menu button */
        .menu-toggle {
            display: none;
            position: fixed;
            top: 15px;
            left: 15px;
            z-index: 1060;
            background: #007bff;
            border: none;
            color: white;
            padding: 10px 14px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.2);
            transition: all 0.3s ease;
            font-size: 18px;
        }
        
        .menu-toggle:hover {
            background: #0056b3;
            transform: scale(1.05);
            box-shadow: 0 6px 16px rgba(0,0,0,0.3);
        }
        
        @media (max-width: 767.98px) {
            .menu-toggle {
                display: block;
            }
        }
        
        /* Additional responsive improvements */
        @media (max-width: 575.98px) {
            .sidebar {
                width: 100%;
                left: -100%;
            }
            
            .menu-toggle {
                top: 10px;
                left: 10px;
                padding: 8px 12px;
            }
        }
        
        /* Prevent body scroll when sidebar is open on mobile */
        body.sidebar-open {
            overflow: hidden;
        }
    </style>
</head>
<body>
<!-- Mobile menu button -->
<button class="menu-toggle" onclick="toggleSidebar()" aria-label="Toggle Sidebar">
    <i class="bi bi-list"></i>
</button>

<!-- Overlay for mobile -->
<div class="sidebar-overlay" onclick="toggleSidebar()"></div>

<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-md-3 col-lg-2 sidebar p-0">
            <div class="p-4">
                <div class="text-center mb-4">
                    <?php if ($shop && $shop['logo_image']): ?>
                        <img src="../uploads/<?= htmlspecialchars($shop['logo_image']) ?>" 
                             alt="Logo Kedai" 
                             class="img-fluid mb-3" 
                             style="max-height: 80px; max-width: 100%; border-radius: 8px;">
                    <?php endif; ?>
                    <h4 class="mb-0"><i class="bi bi-shop"></i> Sistem Tempahan</h4>
                    <small class="text-white-50"><?= htmlspecialchars($shop['shop_name'] ?? 'ALH DESIGN ENTERPRISE') ?></small>
                </div>
                <nav class="nav flex-column">
                    <a class="nav-link" href="../tempahan.php">
                        <i class="bi bi-plus-circle"></i> Tambah Tempahan
                    </a>
                    <a class="nav-link" href="../index.php">
                        <i class="bi bi-list-ul"></i> Senarai Tempahan
                    </a>
                    <a class="nav-link" href="analisis.php">
                        <i class="bi bi-graph-up"></i> Analisis
                    </a>
                    <hr class="my-3 border-white">
                    <a class="nav-link active" href="index.php">
                        <i class="bi bi-gear"></i> Panel Admin
                    </a>
                    <a class="nav-link" href="users.php">
                        <i class="bi bi-people"></i> Pengurusan Pengguna
                    </a>
                </nav>
                <hr class="my-3 border-white">
                <div class="text-center">
                    <small class="text-white-50">Log masuk sebagai:</small><br>
                    <strong class="text-white"><?= htmlspecialchars($_SESSION['realname']) ?></strong><br>
                    <span class="badge bg-danger"><?= $_SESSION['user_peranan'] ?></span>
                </div>
                <hr class="my-3 border-white">
                <div class="text-center">
                    <a href="logout.php" class="btn btn-outline-light btn-sm">
                        <i class="bi bi-box-arrow-right"></i> Logout
                    </a>
                    <a href="password.php" class="btn btn-outline-light btn-sm mt-2">
                        <i class="bi bi-key"></i> Tukar Password
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Main Content -->
        <div class="col-md-9 col-lg-10 main-content p-4">
            <?php if (isset($_GET['success'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle"></i> Maklumat kedai berjaya dikemaskini!
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            <?php if (isset($_GET['prices'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle"></i> Harga berjaya dikemaskini!
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            <?php if (isset($_GET['delete'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle"></i> Gambar berjaya dipadam!
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="row">
                <!-- Maklumat Kedai -->
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-shop"></i> Maklumat Kedai</h5>
                        </div>
                        <div class="card-body">
                            <form method="post" enctype="multipart/form-data">
                                <div class="mb-3">
                                    <label class="form-label">Nama Kedai</label>
                                    <input type="text" name="shop_name" class="form-control" value="<?= htmlspecialchars($shop['shop_name']) ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Alamat Kedai</label>
                                    <textarea name="shop_address" class="form-control" rows="3" required><?= htmlspecialchars($shop['shop_address']) ?></textarea>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">No Tel Kedai</label>
                                    <input type="text" name="shop_phone" class="form-control" value="<?= htmlspecialchars($shop['shop_phone']) ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Nama Pengurus</label>
                                    <input type="text" name="manager_name" class="form-control" value="<?= htmlspecialchars($shop['manager_name']) ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Nama Bank</label>
                                    <input type="text" name="bank_name" class="form-control" value="<?= htmlspecialchars($shop['bank_name']) ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">No Akaun Bank</label>
                                    <input type="text" name="bank_account" class="form-control" value="<?= htmlspecialchars($shop['bank_account']) ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Nama Pemilik Bank</label>
                                    <input type="text" name="bank_owner" class="form-control" value="<?= htmlspecialchars($shop['bank_owner']) ?>" required>
                                </div>
                                
                                <!-- Logo -->
                                <div class="mb-3">
                                    <label class="form-label">Logo Kedai (jpg/png, biar kosong jika tak ubah)</label>
                                    <input type="file" name="logo_image" class="form-control" accept=".jpg,.jpeg,.png">
                                    <?php if ($shop['logo_image']): ?>
                                        <div class="mt-2">
                                            <img src="../uploads/<?= htmlspecialchars($shop['logo_image']) ?>" alt="Logo" style="max-height: 60px; max-width: 200px;" class="border rounded">
                                            <form method="post" class="d-inline">
                                                <button type="submit" name="delete_logo" class="btn btn-danger btn-sm ms-2" onclick="return confirm('Padam logo?')">
                                                    <i class="bi bi-trash"></i> Padam
                                                </button>
                                            </form>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                
                                <!-- Stamp -->
                                <div class="mb-3">
                                    <label class="form-label">Gambar Cop (jpg/png, biar kosong jika tak ubah)</label>
                                    <input type="file" name="stamp_image" class="form-control" accept=".jpg,.jpeg,.png">
                                    <?php if ($shop['stamp_image']): ?>
                                        <div class="mt-2">
                                            <img src="../uploads/<?= htmlspecialchars($shop['stamp_image']) ?>" alt="Stamp" style="max-height: 60px; max-width: 200px;" class="border rounded">
                                            <form method="post" class="d-inline">
                                                <button type="submit" name="delete_stamp" class="btn btn-danger btn-sm ms-2" onclick="return confirm('Padam gambar cop?')">
                                                    <i class="bi bi-trash"></i> Padam
                                                </button>
                                            </form>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                
                                <!-- Signature -->
                                <div class="mb-3">
                                    <label class="form-label">Gambar Tandatangan (jpg/png, biar kosong jika tak ubah)</label>
                                    <input type="file" name="sign_image" class="form-control" accept=".jpg,.jpeg,.png">
                                    <?php if ($shop['sign_image']): ?>
                                        <div class="mt-2">
                                            <img src="../uploads/<?= htmlspecialchars($shop['sign_image']) ?>" alt="Signature" style="max-height: 60px; max-width: 200px;" class="border rounded">
                                            <form method="post" class="d-inline">
                                                <button type="submit" name="delete_sign" class="btn btn-danger btn-sm ms-2" onclick="return confirm('Padam gambar tandatangan?')">
                                                    <i class="bi bi-trash"></i> Padam
                                                </button>
                                            </form>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                
                                <button type="submit" name="update_shop" class="btn btn-primary btn-modern">
                                    <i class="bi bi-save"></i> Simpan Maklumat Kedai
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
                
                <!-- Harga -->
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-currency-dollar"></i> Harga Jualan & Belian</h5>
                        </div>
                        <div class="card-body">
                            <form method="post">
                                <?php foreach ($prices as $type => $price): ?>
                                <div class="row mb-3">
                                    <div class="col-4">
                                        <label class="form-label"><?= ucfirst(str_replace('_', ' ', $type)) ?></label>
                                    </div>
                                    <div class="col-4">
                                        <label class="form-label">Harga Jualan (RM)</label>
                                        <input type="number" step="0.01" name="prices[<?= $type ?>][sale_price]" class="form-control" value="<?= $price['sale_price'] ?>" required>
                                    </div>
                                    <div class="col-4">
                                        <label class="form-label">Harga Belian (RM)</label>
                                        <input type="number" step="0.01" name="prices[<?= $type ?>][purchase_price]" class="form-control" value="<?= $price['purchase_price'] ?>" required>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                                <button type="submit" name="update_prices" class="btn btn-success btn-modern">
                                    <i class="bi bi-save"></i> Simpan Harga
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
function toggleSidebar() {
    const sidebar = document.querySelector('.sidebar');
    const overlay = document.querySelector('.sidebar-overlay');
    const body = document.body;
    
    sidebar.classList.toggle('show');
    overlay.classList.toggle('show');
    
    // Prevent body scroll when sidebar is open
    if (sidebar.classList.contains('show')) {
        body.classList.add('sidebar-open');
    } else {
        body.classList.remove('sidebar-open');
    }
}

// Close sidebar when clicking on a link (mobile)
document.querySelectorAll('.sidebar .nav-link').forEach(link => {
    link.addEventListener('click', () => {
        if (window.innerWidth <= 767.98) {
            toggleSidebar();
        }
    });
});

// Enhanced window resize handler
window.addEventListener('resize', () => {
    const sidebar = document.querySelector('.sidebar');
    const overlay = document.querySelector('.sidebar-overlay');
    const body = document.body;
    
    if (window.innerWidth > 767.98) {
        sidebar.classList.remove('show');
        overlay.classList.remove('show');
        body.classList.remove('sidebar-open');
    }
});

// Close sidebar on escape key
document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape') {
        const sidebar = document.querySelector('.sidebar');
        if (sidebar.classList.contains('show')) {
            toggleSidebar();
        }
    }
});

// Auto-hide sidebar when clicking outside (for larger screens)
document.addEventListener('click', (e) => {
    const sidebar = document.querySelector('.sidebar');
    const toggle = document.querySelector('.menu-toggle');
    
    if (window.innerWidth <= 767.98 && 
        sidebar.classList.contains('show') && 
        !sidebar.contains(e.target) && 
        !toggle.contains(e.target)) {
        toggleSidebar();
    }
});

// Initialize sidebar state on page load
document.addEventListener('DOMContentLoaded', () => {
    // Ensure sidebar is hidden on mobile on page load
    if (window.innerWidth <= 767.98) {
        const sidebar = document.querySelector('.sidebar');
        const overlay = document.querySelector('.sidebar-overlay');
        const body = document.body;
        
        sidebar.classList.remove('show');
        overlay.classList.remove('show');
        body.classList.remove('sidebar-open');
    }
});
</script>
</body>
</html> 