<?php
// Error reporting untuk debug
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// Check if admin is logged in
if (!isset($_SESSION['user_logged_in']) || $_SESSION['user_peranan'] !== 'Admin') {
    header('Location: ../login.php');
    exit;
}

$msg = '';
$err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];
    
    // Get current user's password from database
    $stmt = $conn->prepare("SELECT password FROM users WHERE iduser = ?");
    $stmt->bind_param('i', $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    
    // Check current password
    if (password_verify($current_password, $user['password'])) {
        if ($new_password === $confirm_password) {
            if (strlen($new_password) >= 6) {
                // Hash new password and update database
                $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                $update_stmt = $conn->prepare("UPDATE users SET password = ? WHERE iduser = ?");
                $update_stmt->bind_param('si', $hashed_password, $_SESSION['user_id']);
                
                if ($update_stmt->execute()) {
                    $msg = 'Password berjaya ditukar!';
                } else {
                    $err = 'Ralat semasa mengemaskini password!';
                }
                $update_stmt->close();
            } else {
                $err = 'Password baru mesti sekurang-kurangnya 6 aksara!';
            }
        } else {
            $err = 'Password baru dan pengesahan password tidak sama!';
        }
    } else {
        $err = 'Password semasa salah!';
    }
    
    $stmt->close();
}

// Include database connection and get shop info for logo
include '../includes/db.php';
$shop = $conn->query("SELECT * FROM shop_info WHERE id=1")->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tukar Password - Sistem Tempahan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body { background: #f8f9fa; }
        .sidebar { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; min-height: 100vh; }
        .main-content { min-height: 100vh; padding: 20px; }
        .card { border: none; box-shadow: 0 2px 8px rgba(0,0,0,0.1); border-radius: 12px; }
        .card-header { background: linear-gradient(45deg, #007bff, #0056b3); color: white; border-radius: 12px 12px 0 0 !important; border: none; }
        .nav-link { border-radius: 8px; margin-bottom: 4px; transition: all 0.3s ease; color: rgba(255,255,255,0.8); }
        .nav-link:hover { background: rgba(255,255,255,0.1); transform: translateX(5px); color: white; }
        .nav-link.active { background: rgba(255,255,255,0.2); color: white !important; }
        .form-control { border-radius: 8px; border: 1px solid #dee2e6; }
        .form-control:focus { border-color: #007bff; box-shadow: 0 0 0 0.2rem rgba(0,123,255,0.25); }
        .btn-modern { border-radius: 8px; padding: 8px 16px; font-weight: 500; transition: all 0.3s ease; }
        .btn-modern:hover { transform: translateY(-2px); box-shadow: 0 4px 12px rgba(0,0,0,0.15); }
        
        /* Table styling */
        .table th { 
            background: #343a40 !important; 
            color: white !important;
            border-top: none; 
            font-weight: 600; 
        }
        
        .table-dark th {
            background: #212529 !important;
            color: white !important;
        }
        
        .table-light th {
            background: #6c757d !important;
            color: white !important;
        }
        
        /* Enhanced responsive sidebar */
        @media (max-width: 767.98px) {
            .sidebar {
                position: fixed;
                top: 0;
                left: -100%;
                height: 100vh;
                z-index: 1050;
                transition: left 0.3s ease;
                width: 280px;
                overflow-y: auto;
            }
            
            .sidebar.show {
                left: 0;
            }
            
            .main-content {
                margin-left: 0 !important;
                width: 100% !important;
            }
            
            /* Enhanced overlay when sidebar is open */
            .sidebar-overlay {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: rgba(0,0,0,0.5);
                z-index: 1040;
                display: none;
                opacity: 0;
                transition: opacity 0.3s ease;
            }
            
            .sidebar-overlay.show {
                display: block;
                opacity: 1;
            }
        }
        
        /* Enhanced mobile menu button */
        .menu-toggle {
            display: none;
            position: fixed;
            top: 15px;
            left: 15px;
            z-index: 1060;
            background: #007bff;
            border: none;
            color: white;
            padding: 10px 14px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.2);
            transition: all 0.3s ease;
            font-size: 18px;
        }
        
        .menu-toggle:hover {
            background: #0056b3;
            transform: scale(1.05);
            box-shadow: 0 6px 16px rgba(0,0,0,0.3);
        }
        
        @media (max-width: 767.98px) {
            .menu-toggle {
                display: block;
            }
        }
        
        /* Additional responsive improvements */
        @media (max-width: 575.98px) {
            .sidebar {
                width: 100%;
                left: -100%;
            }
            
            .menu-toggle {
                top: 10px;
                left: 10px;
                padding: 8px 12px;
            }
        }
        
        /* Prevent body scroll when sidebar is open on mobile */
        body.sidebar-open {
            overflow: hidden;
        }
    </style>
</head>
<body>
<!-- Mobile menu button -->
<button class="menu-toggle" onclick="toggleSidebar()" aria-label="Toggle Sidebar">
    <i class="bi bi-list"></i>
</button>

<!-- Overlay for mobile -->
<div class="sidebar-overlay" onclick="toggleSidebar()"></div>

<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-md-3 col-lg-2 sidebar p-0">
            <div class="p-4">
                <div class="text-center mb-4">
                    <?php if ($shop && $shop['logo_image']): ?>
                        <img src="../uploads/<?= htmlspecialchars($shop['logo_image']) ?>" 
                             alt="Logo Kedai" 
                             class="img-fluid mb-3" 
                             style="max-height: 80px; max-width: 100%; border-radius: 8px;">
                    <?php endif; ?>
                    <h4 class="mb-0"><i class="bi bi-shop"></i> Sistem Tempahan</h4>
                    <small class="text-white-50"><?= htmlspecialchars($shop['shop_name'] ?? 'ALH DESIGN ENTERPRISE') ?></small>
                </div>
                <nav class="nav flex-column">
                    <a class="nav-link" href="../tempahan.php">
                        <i class="bi bi-plus-circle"></i> Tambah Tempahan
                    </a>
                    <a class="nav-link" href="../index.php">
                        <i class="bi bi-list-ul"></i> Senarai Tempahan
                    </a>
                    <a class="nav-link" href="analisis.php">
                        <i class="bi bi-graph-up"></i> Analisis
                    </a>
                    <hr class="my-3 border-white">
                    <a class="nav-link" href="index.php">
                        <i class="bi bi-gear"></i> Panel Admin
                    </a>
                    <a class="nav-link" href="users.php">
                        <i class="bi bi-people"></i> Pengurusan Pengguna
                    </a>
                </nav>
                <hr class="my-3 border-white">
                <div class="text-center">
                    <small class="text-white-50">Log masuk sebagai:</small><br>
                    <strong class="text-white"><?= htmlspecialchars($_SESSION['realname']) ?></strong><br>
                    <span class="badge bg-danger"><?= $_SESSION['user_peranan'] ?></span>
                </div>
                <hr class="my-3 border-white">
                <div class="text-center">
                    <a href="logout.php" class="btn btn-outline-light btn-sm">
                        <i class="bi bi-box-arrow-right"></i> Logout
                    </a>
                    <a href="password.php" class="btn btn-outline-light btn-sm mt-2 active">
                        <i class="bi bi-key"></i> Tukar Password
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Main Content -->
        <div class="col-md-9 col-lg-10 main-content p-4">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2>Tukar Password Admin</h2>
                <a href="index.php" class="btn btn-secondary btn-modern">
                    <i class="bi bi-arrow-left"></i> Kembali ke Panel Admin
                </a>
            </div>

            <?php if ($msg): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle"></i> <?= $msg ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            
            <?php if ($err): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-triangle"></i> <?= $err ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-key"></i> Tukar Password</h5>
                        </div>
                        <div class="card-body">
                            <form method="post">
                                <div class="mb-3">
                                    <label class="form-label">Password Semasa</label>
                                    <input type="password" name="current_password" class="form-control" required>
                                    <small class="text-muted">Masukkan password semasa untuk mengesahkan identiti anda</small>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Password Baru</label>
                                    <input type="password" name="new_password" class="form-control" required>
                                    <small class="text-muted">Password baru mesti sekurang-kurangnya 6 aksara</small>
                                </div>
                                <div class="mb-4">
                                    <label class="form-label">Pengesahan Password Baru</label>
                                    <input type="password" name="confirm_password" class="form-control" required>
                                    <small class="text-muted">Masukkan semula password baru untuk pengesahan</small>
                                </div>
                                <button type="submit" class="btn btn-primary btn-modern">
                                    <i class="bi bi-save"></i> Tukar Password
                                </button>
                            </form>
                        </div>
                    </div>
                    
                    <div class="card mt-4">
                        <div class="card-header">
                            <h6 class="mb-0"><i class="bi bi-info-circle"></i> Maklumat</h6>
                        </div>
                        <div class="card-body">
                            <p class="mb-2"><strong>Username:</strong> <?= htmlspecialchars($_SESSION['username']) ?></p>
                            <p class="mb-2"><strong>Nama:</strong> <?= htmlspecialchars($_SESSION['realname']) ?></p>
                            <p class="mb-2"><strong>Peranan:</strong> <?= $_SESSION['user_peranan'] ?></p>
                            <p class="mb-0"><small class="text-muted">Nota: Password disimpan dalam database dengan hash yang selamat.</small></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
function toggleSidebar() {
    const sidebar = document.querySelector('.sidebar');
    const overlay = document.querySelector('.sidebar-overlay');
    const body = document.body;
    
    sidebar.classList.toggle('show');
    overlay.classList.toggle('show');
    
    // Prevent body scroll when sidebar is open
    if (sidebar.classList.contains('show')) {
        body.classList.add('sidebar-open');
    } else {
        body.classList.remove('sidebar-open');
    }
}

// Close sidebar when clicking on a link (mobile)
document.querySelectorAll('.sidebar .nav-link').forEach(link => {
    link.addEventListener('click', () => {
        if (window.innerWidth <= 767.98) {
            toggleSidebar();
        }
    });
});

// Enhanced window resize handler
window.addEventListener('resize', () => {
    const sidebar = document.querySelector('.sidebar');
    const overlay = document.querySelector('.sidebar-overlay');
    const body = document.body;
    
    if (window.innerWidth > 767.98) {
        sidebar.classList.remove('show');
        overlay.classList.remove('show');
        body.classList.remove('sidebar-open');
    }
});

// Close sidebar on escape key
document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape') {
        const sidebar = document.querySelector('.sidebar');
        if (sidebar.classList.contains('show')) {
            toggleSidebar();
        }
    }
});

// Auto-hide sidebar when clicking outside (for larger screens)
document.addEventListener('click', (e) => {
    const sidebar = document.querySelector('.sidebar');
    const toggle = document.querySelector('.menu-toggle');
    
    if (window.innerWidth <= 767.98 && 
        sidebar.classList.contains('show') && 
        !sidebar.contains(e.target) && 
        !toggle.contains(e.target)) {
        toggleSidebar();
    }
});

// Initialize sidebar state on page load
document.addEventListener('DOMContentLoaded', () => {
    // Ensure sidebar is hidden on mobile on page load
    if (window.innerWidth <= 767.98) {
        const sidebar = document.querySelector('.sidebar');
        const overlay = document.querySelector('.sidebar-overlay');
        const body = document.body;
        
        sidebar.classList.remove('show');
        overlay.classList.remove('show');
        body.classList.remove('sidebar-open');
    }
});
</script>
</body>
</html> 