<?php
// Error reporting untuk debug
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// Check if admin is logged in
if (!isset($_SESSION['user_logged_in']) || $_SESSION['user_peranan'] !== 'Admin') {
    header('Location: ../login.php');
    exit;
}

include '../includes/db.php';

// Get shop info
$shop = $conn->query("SELECT * FROM shop_info WHERE id=1")->fetch_assoc();

$msg = '';
$err = '';

// Process form submissions
if (isset($_POST['add_user'])) {
    $username = trim($_POST['username']);
    $password = $_POST['password'];
    $realname = trim($_POST['realname']);
    $peranan = $_POST['peranan'];
    
    // Check if username already exists
    $check = $conn->prepare("SELECT iduser FROM users WHERE username = ?");
    $check->bind_param('s', $username);
    $check->execute();
    
    if ($check->get_result()->num_rows > 0) {
        $err = 'Username sudah wujud!';
    } else {
        // Hash password
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        
        $stmt = $conn->prepare("INSERT INTO users (username, password, realname, peranan) VALUES (?, ?, ?, ?)");
        $stmt->bind_param('ssss', $username, $hashed_password, $realname, $peranan);
        
        if ($stmt->execute()) {
            $msg = 'Pengguna berjaya ditambah!';
        } else {
            $err = 'Ralat semasa menambah pengguna!';
        }
        $stmt->close();
    }
    $check->close();
}

if (isset($_POST['edit_user'])) {
    $iduser = (int)$_POST['iduser'];
    $username = trim($_POST['username']);
    $realname = trim($_POST['realname']);
    $peranan = $_POST['peranan'];
    $password = $_POST['password'];
    
    // Check if username already exists for other users
    $check = $conn->prepare("SELECT iduser FROM users WHERE username = ? AND iduser != ?");
    $check->bind_param('si', $username, $iduser);
    $check->execute();
    
    if ($check->get_result()->num_rows > 0) {
        $err = 'Username sudah wujud!';
    } else {
        if (!empty($password)) {
            // Update with new password
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $conn->prepare("UPDATE users SET username=?, password=?, realname=?, peranan=? WHERE iduser=?");
            $stmt->bind_param('ssssi', $username, $hashed_password, $realname, $peranan, $iduser);
        } else {
            // Update without password
            $stmt = $conn->prepare("UPDATE users SET username=?, realname=?, peranan=? WHERE iduser=?");
            $stmt->bind_param('sssi', $username, $realname, $peranan, $iduser);
        }
        
        if ($stmt->execute()) {
            $msg = 'Pengguna berjaya dikemaskini!';
        } else {
            $err = 'Ralat semasa mengemaskini pengguna!';
        }
        $stmt->close();
    }
    $check->close();
}

if (isset($_POST['delete_user'])) {
    $iduser = (int)$_POST['iduser'];
    
    // Prevent deleting own account
    if ($iduser == $_SESSION['user_id']) {
        $err = 'Anda tidak boleh memadam akaun sendiri!';
    } else {
        $stmt = $conn->prepare("DELETE FROM users WHERE iduser=?");
        $stmt->bind_param('i', $iduser);
        
        if ($stmt->execute()) {
            $msg = 'Pengguna berjaya dipadam!';
        } else {
            $err = 'Ralat semasa memadam pengguna!';
        }
        $stmt->close();
    }
}

// Get all users
$users = $conn->query("SELECT * FROM users ORDER BY created_at DESC");
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pengurusan Pengguna - Sistem Tempahan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body { background: #f8f9fa; }
        .sidebar { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; min-height: 100vh; }
        .main-content { min-height: 100vh; padding: 20px; }
        .card { border: none; box-shadow: 0 2px 8px rgba(0,0,0,0.1); border-radius: 12px; }
        .card-header { background: linear-gradient(45deg, #007bff, #0056b3); color: white; border-radius: 12px 12px 0 0 !important; border: none; }
        .nav-link { border-radius: 8px; margin-bottom: 4px; transition: all 0.3s ease; color: rgba(255,255,255,0.8); }
        .nav-link:hover { background: rgba(255,255,255,0.1); transform: translateX(5px); color: white; }
        .nav-link.active { background: rgba(255,255,255,0.2); color: white !important; }
        .form-control, .form-select { border-radius: 8px; border: 1px solid #dee2e6; }
        .form-control:focus, .form-select:focus { border-color: #007bff; box-shadow: 0 0 0 0.2rem rgba(0,123,255,0.25); }
        .btn-modern { border-radius: 8px; padding: 8px 16px; font-weight: 500; transition: all 0.3s ease; }
        .btn-modern:hover { transform: translateY(-2px); box-shadow: 0 4px 12px rgba(0,0,0,0.15); }
        
        /* Table styling */
        .table th { 
            background: #343a40 !important; 
            color: white !important;
            border-top: none; 
            font-weight: 600; 
        }
        
        .table-dark th {
            background: #212529 !important;
            color: white !important;
        }
        
        .table-light th {
            background: #6c757d !important;
            color: white !important;
        }
        
        /* Enhanced responsive sidebar */
        @media (max-width: 767.98px) {
            .sidebar {
                position: fixed;
                top: 0;
                left: -100%;
                height: 100vh;
                z-index: 1050;
                transition: left 0.3s ease;
                width: 280px;
                overflow-y: auto;
            }
            
            .sidebar.show {
                left: 0;
            }
            
            .main-content {
                margin-left: 0 !important;
                width: 100% !important;
            }
            
            /* Enhanced overlay when sidebar is open */
            .sidebar-overlay {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: rgba(0,0,0,0.5);
                z-index: 1040;
                display: none;
                opacity: 0;
                transition: opacity 0.3s ease;
            }
            
            .sidebar-overlay.show {
                display: block;
                opacity: 1;
            }
        }
        
        /* Enhanced mobile menu button */
        .menu-toggle {
            display: none;
            position: fixed;
            top: 15px;
            left: 15px;
            z-index: 1060;
            background: #007bff;
            border: none;
            color: white;
            padding: 10px 14px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.2);
            transition: all 0.3s ease;
            font-size: 18px;
        }
        
        .menu-toggle:hover {
            background: #0056b3;
            transform: scale(1.05);
            box-shadow: 0 6px 16px rgba(0,0,0,0.3);
        }
        
        @media (max-width: 767.98px) {
            .menu-toggle {
                display: block;
            }
        }
        
        /* Additional responsive improvements */
        @media (max-width: 575.98px) {
            .sidebar {
                width: 100%;
                left: -100%;
            }
            
            .menu-toggle {
                top: 10px;
                left: 10px;
                padding: 8px 12px;
            }
        }
        
        /* Prevent body scroll when sidebar is open on mobile */
        body.sidebar-open {
            overflow: hidden;
        }
        
        .role-badge {
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 0.75rem;
            font-weight: 500;
        }
        .role-admin { background: #dc3545; color: white; }
        .role-pengurus { background: #fd7e14; color: white; }
        .role-pekerja { background: #20c997; color: white; }
    </style>
</head>
<body>
<!-- Mobile menu button -->
<button class="menu-toggle" onclick="toggleSidebar()" aria-label="Toggle Sidebar">
    <i class="bi bi-list"></i>
</button>

<!-- Overlay for mobile -->
<div class="sidebar-overlay" onclick="toggleSidebar()"></div>

<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-md-3 col-lg-2 sidebar p-0">
            <div class="p-4">
                <div class="text-center mb-4">
                    <?php if ($shop && $shop['logo_image']): ?>
                        <img src="../uploads/<?= htmlspecialchars($shop['logo_image']) ?>" 
                             alt="Logo Kedai" 
                             class="img-fluid mb-3" 
                             style="max-height: 80px; max-width: 100%; border-radius: 8px;">
                    <?php endif; ?>
                    <h4 class="mb-0"><i class="bi bi-shop"></i> Sistem Tempahan</h4>
                    <small class="text-white-50"><?= htmlspecialchars($shop['shop_name'] ?? 'ALH DESIGN ENTERPRISE') ?></small>
                </div>
                <nav class="nav flex-column">
                    <a class="nav-link" href="../tempahan.php">
                        <i class="bi bi-plus-circle"></i> Tambah Tempahan
                    </a>
                    <a class="nav-link" href="../index.php">
                        <i class="bi bi-list-ul"></i> Senarai Tempahan
                    </a>
                    <a class="nav-link" href="analisis.php">
                        <i class="bi bi-graph-up"></i> Analisis
                    </a>
                    <hr class="my-3 border-white">
                    <a class="nav-link" href="index.php">
                        <i class="bi bi-gear"></i> Panel Admin
                    </a>
                    <a class="nav-link active" href="users.php">
                        <i class="bi bi-people"></i> Pengurusan Pengguna
                    </a>
                </nav>
                <hr class="my-3 border-white">
                <div class="text-center">
                    <a href="logout.php" class="btn btn-outline-light btn-sm">
                        <i class="bi bi-box-arrow-right"></i> Logout
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Main Content -->
        <div class="col-md-9 col-lg-10 main-content p-4">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2><i class="bi bi-people"></i> Pengurusan Pengguna</h2>
                <button class="btn btn-primary btn-modern" data-bs-toggle="modal" data-bs-target="#addUserModal">
                    <i class="bi bi-plus-circle"></i> Tambah Pengguna
                </button>
            </div>

            <?php if ($msg): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle"></i> <?= $msg ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            
            <?php if ($err): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-triangle"></i> <?= $err ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-people"></i> Senarai Pengguna</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>Bil</th>
                                    <th>Username</th>
                                    <th>Nama Sebenar</th>
                                    <th>Peranan</th>
                                    <th>Tarikh Dicipta</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1; while($user = $users->fetch_assoc()): ?>
                                <tr>
                                    <td><?= $i++ ?></td>
                                    <td><?= htmlspecialchars($user['username']) ?></td>
                                    <td><?= htmlspecialchars($user['realname']) ?></td>
                                    <td>
                                        <span class="badge role-badge role-<?= strtolower($user['peranan']) ?>">
                                            <?= $user['peranan'] ?>
                                        </span>
                                    </td>
                                    <td><?= date('d/m/Y H:i', strtotime($user['created_at'])) ?></td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editUserModal<?= $user['iduser'] ?>" title="Edit Pengguna">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <?php if ($user['iduser'] != $_SESSION['user_id']): ?>
                                            <button class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteUserModal<?= $user['iduser'] ?>" title="Padam Pengguna">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                
                                <!-- Modal Edit User -->
                                <div class="modal fade" id="editUserModal<?= $user['iduser'] ?>" tabindex="-1">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <form method="post">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Edit Pengguna</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <input type="hidden" name="iduser" value="<?= $user['iduser'] ?>">
                                                    <div class="mb-3">
                                                        <label class="form-label">Username</label>
                                                        <input type="text" name="username" class="form-control" value="<?= htmlspecialchars($user['username']) ?>" required>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label class="form-label">Nama Sebenar</label>
                                                        <input type="text" name="realname" class="form-control" value="<?= htmlspecialchars($user['realname']) ?>" required>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label class="form-label">Peranan</label>
                                                        <select name="peranan" class="form-select" required>
                                                            <option value="Admin" <?= $user['peranan']=='Admin'?'selected':'' ?>>Admin</option>
                                                            <option value="Pengurus" <?= $user['peranan']=='Pengurus'?'selected':'' ?>>Pengurus</option>
                                                            <option value="Pekerja" <?= $user['peranan']=='Pekerja'?'selected':'' ?>>Pekerja</option>
                                                        </select>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label class="form-label">Password Baru (biar kosong jika tak ubah)</label>
                                                        <input type="password" name="password" class="form-control" placeholder="Masukkan password baru">
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                                                    <button type="submit" name="edit_user" class="btn btn-primary">Simpan</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Modal Delete User -->
                                <?php if ($user['iduser'] != $_SESSION['user_id']): ?>
                                <div class="modal fade" id="deleteUserModal<?= $user['iduser'] ?>" tabindex="-1">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <form method="post">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Padam Pengguna</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <input type="hidden" name="iduser" value="<?= $user['iduser'] ?>">
                                                    <div class="alert alert-danger">
                                                        <i class="bi bi-exclamation-triangle"></i>
                                                        <strong>Peringatan!</strong> Anda akan memadam pengguna ini secara kekal.
                                                    </div>
                                                    <p><strong>Username:</strong> <?= htmlspecialchars($user['username']) ?></p>
                                                    <p><strong>Nama:</strong> <?= htmlspecialchars($user['realname']) ?></p>
                                                    <p><strong>Peranan:</strong> <?= $user['peranan'] ?></p>
                                                    <p class="text-danger">Tindakan ini tidak boleh dibatalkan!</p>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                    <button type="submit" name="delete_user" class="btn btn-danger">Padam Pengguna</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Add User -->
<div class="modal fade" id="addUserModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="post">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Pengguna Baru</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Username</label>
                        <input type="text" name="username" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Password</label>
                        <input type="password" name="password" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Nama Sebenar</label>
                        <input type="text" name="realname" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Peranan</label>
                        <select name="peranan" class="form-select" required>
                            <option value="">Pilih Peranan</option>
                            <option value="Admin">Admin</option>
                            <option value="Pengurus">Pengurus</option>
                            <option value="Pekerja">Pekerja</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                    <button type="submit" name="add_user" class="btn btn-primary">Tambah Pengguna</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
function toggleSidebar() {
    const sidebar = document.querySelector('.sidebar');
    const overlay = document.querySelector('.sidebar-overlay');
    const body = document.body;
    
    sidebar.classList.toggle('show');
    overlay.classList.toggle('show');
    
    // Prevent body scroll when sidebar is open
    if (sidebar.classList.contains('show')) {
        body.classList.add('sidebar-open');
    } else {
        body.classList.remove('sidebar-open');
    }
}

// Close sidebar when clicking on a link (mobile)
document.querySelectorAll('.sidebar .nav-link').forEach(link => {
    link.addEventListener('click', () => {
        if (window.innerWidth <= 767.98) {
            toggleSidebar();
        }
    });
});

// Enhanced window resize handler
window.addEventListener('resize', () => {
    const sidebar = document.querySelector('.sidebar');
    const overlay = document.querySelector('.sidebar-overlay');
    const body = document.body;
    
    if (window.innerWidth > 767.98) {
        sidebar.classList.remove('show');
        overlay.classList.remove('show');
        body.classList.remove('sidebar-open');
    }
});

// Close sidebar on escape key
document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape') {
        const sidebar = document.querySelector('.sidebar');
        if (sidebar.classList.contains('show')) {
            toggleSidebar();
        }
    }
});

// Auto-hide sidebar when clicking outside (for larger screens)
document.addEventListener('click', (e) => {
    const sidebar = document.querySelector('.sidebar');
    const toggle = document.querySelector('.menu-toggle');
    
    if (window.innerWidth <= 767.98 && 
        sidebar.classList.contains('show') && 
        !sidebar.contains(e.target) && 
        !toggle.contains(e.target)) {
        toggleSidebar();
    }
});

// Initialize sidebar state on page load
document.addEventListener('DOMContentLoaded', () => {
    // Ensure sidebar is hidden on mobile on page load
    if (window.innerWidth <= 767.98) {
        const sidebar = document.querySelector('.sidebar');
        const overlay = document.querySelector('.sidebar-overlay');
        const body = document.body;
        
        sidebar.classList.remove('show');
        overlay.classList.remove('show');
        body.classList.remove('sidebar-open');
    }
});
</script>
</body>
</html> 