<?php
// Error reporting untuk debug
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// Check if user is logged in
if (!isset($_SESSION['user_logged_in'])) {
    header('Location: login.php');
    exit;
}

// Set variables for header and sidemenu
$page_title = 'Senarai Tempahan';
$active_menu = 'senarai';

// Include database connection
include 'includes/db.php';

// Get shop info for logo
$shop_info = $conn->query("SELECT * FROM shop_info LIMIT 1")->fetch_assoc();

// Proses kemaskini status order
if (isset($_POST['update_status'])) {
    $oid = (int)$_POST['order_id'];
    $status_order = $_POST['status_order'];
    $status_hantar = $_POST['status_hantar'];
    $status_bayar = $_POST['status_bayar'];
    $stmt = $conn->prepare("UPDATE orders SET status_order=?, status_hantar=?, status_bayar=? WHERE id=?");
    $stmt->bind_param('sssi', $status_order, $status_hantar, $status_bayar, $oid);
    $stmt->execute();
    $stmt->close();
    header('Location: index.php?status=1');
    exit;
}

// Proses edit tempahan
if (isset($_POST['edit_order'])) {
    $oid = (int)$_POST['order_id'];
    $customer_name = $_POST['customer_name'];
    $customer_phone = $_POST['customer_phone'];
    $customer_address = $_POST['customer_address'];
    $perkara = $_POST['perkara'];
    $order_date = $_POST['order_date'];
    $due_date = $_POST['due_date'];
    $collar_ss = (int)$_POST['collar_ss'];
    $collar_ls = (int)$_POST['collar_ls'];
    $rn_ss = (int)$_POST['rn_ss'];
    $rn_ls = (int)$_POST['rn_ls'];
    $muslimah = (int)$_POST['muslimah'];
    $shipping_cost = (float)$_POST['shipping_cost'];
    
    // Kira kos keseluruhan (harga jualan)
    $prices = [];
    $res = $conn->query("SELECT * FROM prices");
    while ($row = $res->fetch_assoc()) {
        $prices[$row['item_type']] = $row;
    }
    $total_cost = $collar_ss * $prices['collar_ss']['sale_price'] +
                  $collar_ls * $prices['collar_ls']['sale_price'] +
                  $rn_ss * $prices['rn_ss']['sale_price'] +
                  $rn_ls * $prices['rn_ls']['sale_price'] +
                  $muslimah * $prices['muslimah']['sale_price'] +
                  $shipping_cost;
    // Kira jumlah kos (harga kos)
    $total_cost_price = $collar_ss * $prices['collar_ss']['purchase_price'] +
                       $collar_ls * $prices['collar_ls']['purchase_price'] +
                       $rn_ss * $prices['rn_ss']['purchase_price'] +
                       $rn_ls * $prices['rn_ls']['purchase_price'] +
                       $muslimah * $prices['muslimah']['purchase_price'] +
                       $shipping_cost;
    // Kira jumlah jualan (ikut harga jualan, tanpa shipping)
    $total_sale = $collar_ss * $prices['collar_ss']['sale_price'] +
                  $collar_ls * $prices['collar_ls']['sale_price'] +
                  $rn_ss * $prices['rn_ss']['sale_price'] +
                  $rn_ls * $prices['rn_ls']['sale_price'] +
                  $muslimah * $prices['muslimah']['sale_price'];
    
    $stmt = $conn->prepare("UPDATE orders SET customer_name=?, customer_phone=?, customer_address=?, perkara=?, order_date=?, due_date=?, collar_ss=?, collar_ls=?, rn_ss=?, rn_ls=?, muslimah=?, shipping_cost=?, total_cost=?, total_cost_price=?, total_sale=? WHERE id=?");
    $stmt->bind_param('sssssssiiiiddddi', $customer_name, $customer_phone, $customer_address, $perkara, $order_date, $due_date, $collar_ss, $collar_ls, $rn_ss, $rn_ls, $muslimah, $shipping_cost, $total_cost, $total_cost_price, $total_sale, $oid);
    $stmt->execute();
    $stmt->close();
    header('Location: index.php?edit=1');
    exit;
}

// Proses delete tempahan
if (isset($_POST['delete_order'])) {
    $oid = (int)$_POST['order_id'];
    $stmt = $conn->prepare("DELETE FROM orders WHERE id=?");
    $stmt->bind_param('i', $oid);
    $stmt->execute();
    $stmt->close();
    header('Location: index.php?delete=1');
    exit;
}

// Dapatkan senarai tempahan
$orders = $conn->query("SELECT * FROM orders ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Senarai Tempahan - Sistem Tempahan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body { background: #f8f9fa; }
        .sidebar { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; min-height: 100vh; }
        .main-content { min-height: 100vh; padding: 20px; }
        .card { border: none; box-shadow: 0 2px 8px rgba(0,0,0,0.1); border-radius: 12px; }
        .card-header { background: linear-gradient(45deg, #007bff, #0056b3); color: white; border-radius: 12px 12px 0 0 !important; border: none; }
        .nav-link { border-radius: 8px; margin-bottom: 4px; transition: all 0.3s ease; color: rgba(255,255,255,0.8); }
        .nav-link:hover { background: rgba(255,255,255,0.1); transform: translateX(5px); color: white; }
        .nav-link.active { background: rgba(255,255,255,0.2); color: white !important; }
        .status-badge { font-size: 0.75rem; padding: 4px 8px; margin: 1px; }
        
        /* Table styling */
        .table th { 
            background: #343a40 !important; 
            color: white !important;
            border-top: none; 
            font-weight: 600; 
        }
        
        .table-dark th {
            background: #212529 !important;
            color: white !important;
        }
        
        .table-light th {
            background: #6c757d !important;
            color: white !important;
        }
        
        /* Enhanced responsive sidebar */
        @media (max-width: 767.98px) {
            .sidebar {
                position: fixed;
                top: 0;
                left: -100%;
                height: 100vh;
                z-index: 1050;
                transition: left 0.3s ease;
                width: 280px;
                overflow-y: auto;
            }
            
            .sidebar.show {
                left: 0;
            }
            
            .main-content {
                margin-left: 0 !important;
                width: 100% !important;
            }
            
            /* Enhanced overlay when sidebar is open */
            .sidebar-overlay {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: rgba(0,0,0,0.5);
                z-index: 1040;
                display: none;
                opacity: 0;
                transition: opacity 0.3s ease;
            }
            
            .sidebar-overlay.show {
                display: block;
                opacity: 1;
            }
        }
        
        /* Enhanced mobile menu button */
        .menu-toggle {
            display: none;
            position: fixed;
            top: 15px;
            left: 15px;
            z-index: 1060;
            background: #007bff;
            border: none;
            color: white;
            padding: 10px 14px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.2);
            transition: all 0.3s ease;
            font-size: 18px;
        }
        
        .menu-toggle:hover {
            background: #0056b3;
            transform: scale(1.05);
            box-shadow: 0 6px 16px rgba(0,0,0,0.3);
        }
        
        @media (max-width: 767.98px) {
            .menu-toggle {
                display: block;
            }
        }
        
        /* Additional responsive improvements */
        @media (max-width: 575.98px) {
            .sidebar {
                width: 100%;
                left: -100%;
            }
            
            .menu-toggle {
                top: 10px;
                left: 10px;
                padding: 8px 12px;
            }
        }
        
        /* Prevent body scroll when sidebar is open on mobile */
        body.sidebar-open {
            overflow: hidden;
        }
    </style>
</head>
<body>
<!-- Mobile menu button -->
<button class="menu-toggle" onclick="toggleSidebar()">
    <i class="bi bi-list"></i>
</button>

<!-- Overlay for mobile -->
<div class="sidebar-overlay" onclick="toggleSidebar()"></div>

<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-md-3 col-lg-2 sidebar p-0">
            <div class="p-4">
                <div class="text-center mb-4">
                    <?php if ($shop_info && $shop_info['logo_image']): ?>
                        <img src="uploads/<?= htmlspecialchars($shop_info['logo_image']) ?>" 
                             alt="Logo Kedai" 
                             class="img-fluid mb-3" 
                             style="max-height: 80px; max-width: 100%; border-radius: 8px;">
                    <?php endif; ?>
                    <h4 class="mb-0"><i class="bi bi-shop"></i> Sistem Tempahan</h4>
                    <small class="text-white-50">ALH DESIGN ENTERPRISE</small>
                </div>
                <nav class="nav flex-column">
                    <a class="nav-link" href="tempahan.php">
                        <i class="bi bi-plus-circle"></i> Tambah Tempahan
                    </a>
                    <a class="nav-link active" href="index.php">
                        <i class="bi bi-list-ul"></i> Senarai Tempahan
                    </a>
                    <?php if ($_SESSION['user_peranan'] === 'Admin'): ?>
                    <a class="nav-link" href="admin/analisis.php">
                        <i class="bi bi-graph-up"></i> Analisis
                    </a>
                    <?php endif; ?>
                    <hr class="my-3 border-white">
                                <?php if ($_SESSION['user_peranan'] === 'Admin'): ?>
            <a class="nav-link" href="admin/">
                <i class="bi bi-gear"></i> Panel Admin
            </a>
            <?php endif; ?>
            <hr class="my-3 border-white">
            <div class="text-center">
                <small class="text-white-50">Log masuk sebagai:</small><br>
                <strong class="text-white"><?= htmlspecialchars($_SESSION['realname']) ?></strong><br>
                <span class="badge bg-<?= $_SESSION['user_peranan'] === 'Admin' ? 'danger' : ($_SESSION['user_peranan'] === 'Pengurus' ? 'warning' : 'success') ?>">
                    <?= $_SESSION['user_peranan'] ?>
                </span>
            </div>
            <hr class="my-3 border-white">
            <div class="text-center">
                <a href="admin/logout.php" class="btn btn-outline-light btn-sm">
                    <i class="bi bi-box-arrow-right"></i> Logout
                </a>
            </div>
                </nav>
            </div>
        </div>
        
        <!-- Main Content -->
        <div class="col-md-9 col-lg-10 main-content p-4">
            <!-- Success Message -->
            <?php if (isset($_GET['status'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle"></i> Status tempahan berjaya dikemaskini!
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            <?php if (isset($_GET['edit'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle"></i> Tempahan berjaya dikemaskini!
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            <?php if (isset($_GET['delete'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle"></i> Tempahan berjaya dipadam!
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-list-ul"></i> Senarai Tempahan</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>Bil</th>
                                    <th>Nama</th>
                                    <th>No Tel</th>
                                    <th>Tarikh Order</th>
                                    <th>Jualan (RM)</th>
                                    <th>Status</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1; $orders->data_seek(0); while($row = $orders->fetch_assoc()): ?>
                                <tr>
                                    <td><?= $i++ ?></td>
                                    <td><?= htmlspecialchars($row['customer_name']) ?></td>
                                    <td><?= htmlspecialchars($row['customer_phone']) ?></td>
                                    <td><?= $row['order_date'] ?></td>
                                    <td><?= number_format($row['total_sale'],2) ?></td>
                                    <td>
                                        <span class="badge status-badge bg-<?= $row['status_order']==='Siap'?'success':($row['status_order']==='Batal'?'danger':'secondary') ?>"><?= $row['status_order'] ?></span>
                                        <span class="badge status-badge bg-<?= $row['status_hantar']==='Sudah'?'info':'secondary' ?>"><?= $row['status_hantar'] ?></span>
                                        <span class="badge status-badge bg-<?= $row['status_bayar']==='Sudah'?'primary':'secondary' ?>"><?= $row['status_bayar'] ?></span>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="invoice/invoice.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-success" target="_blank" title="Cetak Invoice">
                                                <i class="bi bi-printer"></i>
                                            </a>
                                            <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editModal<?= $row['id'] ?>" title="Edit Tempahan">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#statusModal<?= $row['id'] ?>" title="Kemaskini Status">
                                                <i class="bi bi-gear"></i>
                                            </button>
                                            <button class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteModal<?= $row['id'] ?>" title="Padam Tempahan">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                
                                <!-- Modal Edit Tempahan -->
                                <div class="modal fade" id="editModal<?= $row['id'] ?>" tabindex="-1">
                                  <div class="modal-dialog modal-lg">
                                    <div class="modal-content">
                                      <form method="post">
                                      <div class="modal-header">
                                        <h5 class="modal-title">Edit Tempahan #<?= $row['id'] ?></h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                      </div>
                                      <div class="modal-body">
                                        <input type="hidden" name="order_id" value="<?= $row['id'] ?>">
                                        <div class="row mb-3">
                                            <div class="col-md-6">
                                                <label class="form-label">Nama Pelanggan</label>
                                                <input type="text" name="customer_name" class="form-control" value="<?= htmlspecialchars($row['customer_name']) ?>" required>
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label">No Tel</label>
                                                <input type="text" name="customer_phone" class="form-control" value="<?= htmlspecialchars($row['customer_phone']) ?>" required>
                                            </div>
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Alamat Pelanggan</label>
                                            <textarea name="customer_address" class="form-control" rows="3" required><?= htmlspecialchars($row['customer_address']) ?></textarea>
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Perkara</label>
                                            <textarea name="perkara" class="form-control" rows="3" placeholder="Masukkan perkara atau butiran tempahan..."><?= htmlspecialchars($row['perkara']) ?></textarea>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-md-6">
                                                <label class="form-label">Tarikh Order</label>
                                                <input type="date" name="order_date" class="form-control" value="<?= $row['order_date'] ?>" required>
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label">Tarikh Siap</label>
                                                <input type="date" name="due_date" class="form-control" value="<?= $row['due_date'] ?>">
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-md-2">
                                                <label class="form-label">Kolar SS</label>
                                                <input type="number" name="collar_ss" class="form-control" min="0" value="<?= $row['collar_ss'] ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <label class="form-label">Kolar LS</label>
                                                <input type="number" name="collar_ls" class="form-control" min="0" value="<?= $row['collar_ls'] ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <label class="form-label">RN SS</label>
                                                <input type="number" name="rn_ss" class="form-control" min="0" value="<?= $row['rn_ss'] ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <label class="form-label">RN LS</label>
                                                <input type="number" name="rn_ls" class="form-control" min="0" value="<?= $row['rn_ls'] ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <label class="form-label">Muslimah</label>
                                                <input type="number" name="muslimah" class="form-control" min="0" value="<?= $row['muslimah'] ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <label class="form-label">Kos Pos (RM)</label>
                                                <input type="number" step="0.01" name="shipping_cost" class="form-control" min="0" value="<?= $row['shipping_cost'] ?>">
                                            </div>
                                        </div>
                                      </div>
                                      <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                                        <button type="submit" name="edit_order" class="btn btn-primary">Simpan Perubahan</button>
                                      </div>
                                      </form>
                                    </div>
                                  </div>
                                </div>
                                
                                <!-- Modal Status -->
                                <div class="modal fade" id="statusModal<?= $row['id'] ?>" tabindex="-1">
                                  <div class="modal-dialog">
                                    <div class="modal-content">
                                      <form method="post">
                                      <div class="modal-header">
                                        <h5 class="modal-title">Kemaskini Status Tempahan #<?= $row['id'] ?></h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                      </div>
                                      <div class="modal-body">
                                        <input type="hidden" name="order_id" value="<?= $row['id'] ?>">
                                        <div class="mb-3">
                                            <label class="form-label">Status Order</label>
                                            <select name="status_order" class="form-select">
                                                <option <?= $row['status_order']==='Baru'?'selected':'' ?>>Baru</option>
                                                <option <?= $row['status_order']==='Siap'?'selected':'' ?>>Siap</option>
                                                <option <?= $row['status_order']==='Batal'?'selected':'' ?>>Batal</option>
                                            </select>
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Status Penghantaran</label>
                                            <select name="status_hantar" class="form-select">
                                                <option <?= $row['status_hantar']==='Belum'?'selected':'' ?>>Belum</option>
                                                <option <?= $row['status_hantar']==='Sudah'?'selected':'' ?>>Sudah</option>
                                            </select>
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Status Bayaran</label>
                                            <select name="status_bayar" class="form-select">
                                                <option <?= $row['status_bayar']==='Belum'?'selected':'' ?>>Belum</option>
                                                <option <?= $row['status_bayar']==='Sudah'?'selected':'' ?>>Sudah</option>
                                            </select>
                                        </div>
                                      </div>
                                      <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                                        <button type="submit" name="update_status" class="btn btn-primary">Simpan</button>
                                      </div>
                                      </form>
                                    </div>
                                  </div>
                                </div>
                                
                                <!-- Modal Delete -->
                                <div class="modal fade" id="deleteModal<?= $row['id'] ?>" tabindex="-1">
                                  <div class="modal-dialog">
                                    <div class="modal-content">
                                      <form method="post">
                                      <div class="modal-header">
                                        <h5 class="modal-title">Padam Tempahan #<?= $row['id'] ?></h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                      </div>
                                      <div class="modal-body">
                                        <input type="hidden" name="order_id" value="<?= $row['id'] ?>">
                                        <div class="alert alert-danger">
                                            <i class="bi bi-exclamation-triangle"></i>
                                            <strong>Peringatan!</strong> Anda akan memadam tempahan ini secara kekal.
                                        </div>
                                        <p><strong>Nama Pelanggan:</strong> <?= htmlspecialchars($row['customer_name']) ?></p>
                                        <p><strong>Tarikh Order:</strong> <?= $row['order_date'] ?></p>
                                        <p><strong>Jualan:</strong> RM <?= number_format($row['total_sale'],2) ?></p>
                                        <p class="text-danger">Tindakan ini tidak boleh dibatalkan!</p>
                                      </div>
                                      <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                        <button type="submit" name="delete_order" class="btn btn-danger">Padam Tempahan</button>
                                      </div>
                                      </form>
                                    </div>
                                  </div>
                                </div>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
function toggleSidebar() {
    const sidebar = document.querySelector('.sidebar');
    const overlay = document.querySelector('.sidebar-overlay');
    const body = document.body;
    
    sidebar.classList.toggle('show');
    overlay.classList.toggle('show');
    
    // Prevent body scroll when sidebar is open
    if (sidebar.classList.contains('show')) {
        body.classList.add('sidebar-open');
    } else {
        body.classList.remove('sidebar-open');
    }
}

// Close sidebar when clicking on a link (mobile)
document.querySelectorAll('.sidebar .nav-link').forEach(link => {
    link.addEventListener('click', () => {
        if (window.innerWidth <= 767.98) {
            toggleSidebar();
        }
    });
});

// Enhanced window resize handler
window.addEventListener('resize', () => {
    const sidebar = document.querySelector('.sidebar');
    const overlay = document.querySelector('.sidebar-overlay');
    const body = document.body;
    
    if (window.innerWidth > 767.98) {
        sidebar.classList.remove('show');
        overlay.classList.remove('show');
        body.classList.remove('sidebar-open');
    }
});

// Close sidebar on escape key
document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape') {
        const sidebar = document.querySelector('.sidebar');
        if (sidebar.classList.contains('show')) {
            toggleSidebar();
        }
    }
});

// Auto-hide sidebar when clicking outside (for larger screens)
document.addEventListener('click', (e) => {
    const sidebar = document.querySelector('.sidebar');
    const toggle = document.querySelector('.menu-toggle');
    
    if (window.innerWidth <= 767.98 && 
        sidebar.classList.contains('show') && 
        !sidebar.contains(e.target) && 
        !toggle.contains(e.target)) {
        toggleSidebar();
    }
});

// Initialize sidebar state on page load
document.addEventListener('DOMContentLoaded', () => {
    // Ensure sidebar is hidden on mobile on page load
    if (window.innerWidth <= 767.98) {
        const sidebar = document.querySelector('.sidebar');
        const overlay = document.querySelector('.sidebar-overlay');
        const body = document.body;
        
        sidebar.classList.remove('show');
        overlay.classList.remove('show');
        body.classList.remove('sidebar-open');
    }
});
</script>
</body>
</html> 